/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import pneumaticCraft.common.inventory.ContainerLogistics;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.semiblock.SemiBlockManager;

public class PacketSetLogisticsFilterStack
extends LocationIntPacket<PacketSetLogisticsFilterStack> {
    private ItemStack settingStack;
    private int settingIndex;

    public PacketSetLogisticsFilterStack() {
    }

    public PacketSetLogisticsFilterStack(SemiBlockLogistics logistics, ItemStack stack, int index) {
        super(logistics.getPos().field_151329_a, logistics.getPos().field_151327_b, logistics.getPos().field_151328_c);
        this.settingStack = stack;
        this.settingIndex = index;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.settingStack);
        buf.writeInt(this.settingIndex);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.settingStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.settingIndex = buf.readInt();
    }

    @Override
    public void handleClientSide(PacketSetLogisticsFilterStack message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketSetLogisticsFilterStack message, EntityPlayer player) {
        if (message.x == 0 && message.y == 0 && message.z == 0) {
            if (player.field_71070_bA instanceof ContainerLogistics) {
                ((ContainerLogistics)player.field_71070_bA).logistics.getFilters().func_70299_a(message.settingIndex, message.settingStack);
            }
        } else {
            ISemiBlock semiBlock = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(player.field_70170_p, message.x, message.y, message.z);
            if (semiBlock instanceof SemiBlockLogistics) {
                ((SemiBlockLogistics)semiBlock).getFilters().func_70299_a(message.settingIndex, message.settingStack);
            }
        }
    }
}

