/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.gui.GuiRemote;
import pneumaticCraft.common.network.AbstractPacket;
import pneumaticCraft.common.remote.GlobalVariableManager;

public class PacketSetGlobalVariable
extends AbstractPacket<PacketSetGlobalVariable> {
    private String varName;
    private ChunkPosition value;

    public PacketSetGlobalVariable() {
    }

    public PacketSetGlobalVariable(String varName, ChunkPosition value) {
        this.varName = varName;
        this.value = value;
    }

    public PacketSetGlobalVariable(String varName, int value) {
        this(varName, new ChunkPosition(value, 0, 0));
    }

    public PacketSetGlobalVariable(String varName, boolean value) {
        this(varName, value ? 1 : 0);
    }

    public void fromBytes(ByteBuf buf) {
        this.varName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.value = new ChunkPosition(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.varName);
        buf.writeInt(this.value.field_151329_a);
        buf.writeInt(this.value.field_151327_b);
        buf.writeInt(this.value.field_151328_c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(PacketSetGlobalVariable message, EntityPlayer player) {
        this.handleServerSide(message, player);
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiRemote) {
            ((GuiRemote)screen).onGlobalVariableChange(message.varName);
        }
    }

    @Override
    public void handleServerSide(PacketSetGlobalVariable message, EntityPlayer player) {
        GlobalVariableManager.getInstance().set(message.varName, message.value);
    }
}

