/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.api.tileentity.IManoMeasurable;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.item.ItemPressurizable;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;

public class ItemManometer
extends ItemPressurizable {
    public ItemManometer(String textureLocation) {
        super(textureLocation, 30000, 3000);
    }

    public boolean onItemUseFirst(ItemStack iStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (world.field_72995_K) {
            return false;
        }
        if (((IPressurizable)iStack.func_77973_b()).getPressure(iStack) > 0.0f) {
            TileEntity te = world.func_147438_o(x, y, z);
            IPneumaticMachine machine = ModInteractionUtils.getInstance().getMachine(te);
            ArrayList<ChatComponentTranslation> curInfo = new ArrayList<ChatComponentTranslation>();
            ArrayList<String> info = new ArrayList<String>();
            if (te instanceof IManoMeasurable) {
                ((IManoMeasurable)te).printManometerMessage(player, info);
            } else if (machine != null) {
                machine.getAirHandler().printManometerMessage(player, info);
            }
            for (String string : info) {
                curInfo.add(new ChatComponentTranslation(string, new Object[0]));
            }
            if (te instanceof IHeatExchanger) {
                IHeatExchangerLogic exchanger = ((IHeatExchanger)te).getHeatExchangerLogic(ForgeDirection.getOrientation((int)side));
                if (exchanger != null) {
                    curInfo.add(new ChatComponentTranslation("waila.temperature", new Object[]{(int)exchanger.getTemperature() - 273}));
                } else {
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        exchanger = ((IHeatExchanger)te).getHeatExchangerLogic(d);
                        if (exchanger == null) continue;
                        curInfo.add(new ChatComponentTranslation("waila.temperature." + d.toString().toLowerCase(), new Object[]{(int)exchanger.getTemperature() - 273}));
                    }
                }
            }
            if (curInfo.size() > 0) {
                ((IPressurizable)iStack.func_77973_b()).addAir(iStack, -30);
                for (IChatComponent iChatComponent : curInfo) {
                    player.func_146105_b(iChatComponent);
                }
                return true;
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.RED + "The Manometer doesn't have any charge!", new Object[0]));
            return false;
        }
        return false;
    }

    public boolean func_111207_a(ItemStack iStack, EntityPlayer player, EntityLivingBase entity) {
        if (!player.field_70170_p.field_72995_K && entity instanceof IManoMeasurable) {
            if (((IPressurizable)iStack.func_77973_b()).getPressure(iStack) > 0.0f) {
                ArrayList<String> curInfo = new ArrayList<String>();
                ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                if (curInfo.size() > 0) {
                    ((IPressurizable)iStack.func_77973_b()).addAir(iStack, -30);
                    for (String s : curInfo) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(s, new Object[0]));
                    }
                    return true;
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.RED + "The Manometer doesn't have any charge!", new Object[0]));
            }
        }
        return false;
    }
}

