/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.heat.behaviour;

import java.util.HashSet;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import pneumaticCraft.common.heat.behaviour.HeatBehaviourLiquid;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketPlaySound;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.util.FluidUtils;

public abstract class HeatBehaviourLiquidTransition
extends HeatBehaviourLiquid {
    private double extractedHeat;
    private double maxExchangedHeat;
    private int fluidTemp = -1;

    @Override
    public boolean isApplicable() {
        Fluid fluid = this.getFluid();
        return fluid != null && fluid.getTemperature() >= this.getMinFluidTemp() && fluid.getTemperature() <= this.getMaxFluidTemp();
    }

    protected abstract int getMinFluidTemp();

    protected abstract int getMaxFluidTemp();

    protected abstract int getMaxExchangedHeat();

    protected abstract Block getTransitionedSourceBlock();

    protected abstract Block getTransitionedFlowingBlock();

    protected abstract boolean transitionOnTooMuchExtraction();

    @Override
    public void update() {
        if (this.fluidTemp == -1) {
            this.fluidTemp = this.getFluid().getTemperature();
            this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (10.0 + this.getHeatExchanger().getThermalResistance());
        }
        this.extractedHeat += (double)this.fluidTemp - this.getHeatExchanger().getTemperature();
        if (this.transitionOnTooMuchExtraction() ? this.extractedHeat > this.maxExchangedHeat : this.extractedHeat < -this.maxExchangedHeat) {
            this.transformSourceBlock(this.getTransitionedSourceBlock(), this.getTransitionedFlowingBlock());
            this.extractedHeat -= this.maxExchangedHeat;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("extractedHeat", this.extractedHeat);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.extractedHeat = tag.func_74769_h("extractedHeat");
    }

    protected void transformSourceBlock(Block turningBlockSource, Block turningBlockFlowing) {
        if (FluidUtils.isSourceBlock(this.getWorld(), this.getX(), this.getY(), this.getZ())) {
            this.getWorld().func_147449_b(this.getX(), this.getY(), this.getZ(), turningBlockSource);
            this.onLiquidTransition(this.getX(), this.getY(), this.getZ());
        } else {
            HashSet<ChunkPosition> traversed = new HashSet<ChunkPosition>();
            Stack<ChunkPosition> pending = new Stack<ChunkPosition>();
            pending.push(new ChunkPosition(this.getX(), this.getY(), this.getZ()));
            while (!pending.isEmpty()) {
                ChunkPosition pos = (ChunkPosition)pending.pop();
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    ChunkPosition newPos = new ChunkPosition(pos.field_151329_a + d.offsetX, pos.field_151327_b + d.offsetY, pos.field_151328_c + d.offsetZ);
                    Block checkingBlock = this.getWorld().func_147439_a(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c);
                    if (checkingBlock != this.getBlock() && (this.getBlock() != Blocks.field_150358_i || checkingBlock != Blocks.field_150355_j) && (this.getBlock() != Blocks.field_150356_k || checkingBlock != Blocks.field_150353_l) || !traversed.add(newPos)) continue;
                    if (FluidUtils.isSourceBlock(this.getWorld(), newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c)) {
                        this.getWorld().func_147449_b(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c, turningBlockSource);
                        this.onLiquidTransition(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c);
                        return;
                    }
                    this.getWorld().func_147449_b(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c, turningBlockFlowing);
                    this.onLiquidTransition(newPos.field_151329_a, newPos.field_151327_b, newPos.field_151328_c);
                    pending.push(newPos);
                }
            }
        }
    }

    protected void onLiquidTransition(int x, int y, int z) {
        NetworkHandler.sendToAllAround(new PacketPlaySound("random.fizz", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f, true), this.getWorld());
        for (int i = 0; i < 8; ++i) {
            double randX = (double)x + this.getWorld().field_73012_v.nextDouble();
            double randZ = (double)z + this.getWorld().field_73012_v.nextDouble();
            NetworkHandler.sendToAllAround(new PacketSpawnParticle("largesmoke", randX, y + 1, randZ, 0.0, 0.0, 0.0), this.getWorld());
        }
    }
}

