/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.heat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.heat.HeatExchangerLogicConstant;
import pneumaticCraft.lib.Log;

public class HeatExchangerManager {
    private final Map<Block, IHeatExchanger> specialBlockExchangers = new HashMap<Block, IHeatExchanger>();
    private final IHeatExchangerLogic AIR_EXCHANGER = new HeatExchangerLogicConstant(295.0, 100.0);
    public static final double FLUID_RESISTANCE = 10.0;
    private static HeatExchangerManager INSTANCE = new HeatExchangerManager();

    public static HeatExchangerManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        PneumaticRegistry.getInstance().registerBlockExchanger(Blocks.field_150432_aD, 263.0, 500.0);
        PneumaticRegistry.getInstance().registerBlockExchanger(Blocks.field_150403_cj, 263.0, 500.0);
        PneumaticRegistry.getInstance().registerBlockExchanger(Blocks.field_150433_aE, 268.0, 1000.0);
        PneumaticRegistry.getInstance().registerBlockExchanger(Blocks.field_150478_aa, 1700.0, 100000.0);
        PneumaticRegistry.getInstance().registerBlockExchanger((Block)Blocks.field_150480_ab, 1700.0, 1000.0);
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid fluid : fluids.values()) {
            if (fluid.getBlock() == null) continue;
            PneumaticRegistry.getInstance().registerBlockExchanger(fluid.getBlock(), fluid.getTemperature(), 10.0);
        }
        PneumaticRegistry.getInstance().registerBlockExchanger((Block)Blocks.field_150358_i, FluidRegistry.WATER.getTemperature(), 500.0);
        PneumaticRegistry.getInstance().registerBlockExchanger((Block)Blocks.field_150356_k, FluidRegistry.LAVA.getTemperature(), 500.0);
    }

    public IHeatExchangerLogic getLogic(World world, int x, int y, int z, ForgeDirection side) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IHeatExchanger) {
            return ((IHeatExchanger)te).getHeatExchangerLogic(side);
        }
        if (world.func_147437_c(x, y, z)) {
            return this.AIR_EXCHANGER;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IHeatExchanger) {
            return ((IHeatExchanger)block).getHeatExchangerLogic(side);
        }
        IHeatExchanger exchanger = this.specialBlockExchangers.get(block);
        return exchanger == null ? null : exchanger.getHeatExchangerLogic(side);
    }

    public void registerBlockExchanger(Block block, IHeatExchanger heatExchanger) {
        if (block == null) {
            throw new IllegalArgumentException("block is null when trying to register a heat exchanger!");
        }
        if (block instanceof IHeatExchanger) {
            Log.warning("The block " + block.func_149739_a() + " is implementing IHeatExchanger. Therefore you don't need to register it as such");
        }
        if (this.specialBlockExchangers.containsKey(block)) {
            Log.error("The block " + block.func_149739_a() + " was registered as heat exchanger already! It won't be added!");
        } else {
            this.specialBlockExchangers.put(block, heatExchanger);
        }
    }
}

