/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.fluid;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.common.block.BlockFluidEtchingAcid;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.fluid.FluidPlastic;
import pneumaticCraft.common.fluid.FluidPneumaticCraft;
import pneumaticCraft.common.item.ItemPneumatic;
import pneumaticCraft.common.item.Itemss;

public class Fluids {
    public static final Fluid etchingAcid = new FluidPneumaticCraft("etchacid", false){

        public int getColor() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.getBlock().func_149720_d(null, 0, 0, 0);
            }
            return super.getColor();
        }
    };
    public static final Fluid plastic = new FluidPlastic("plastic");
    public static final Fluid oil = new FluidPneumaticCraft("oil").setDensity(800).setViscosity(10000);
    public static final Fluid lpg = new FluidPneumaticCraft("lpg");
    public static final Fluid gasoline = new FluidPneumaticCraft("fuel");
    public static final Fluid kerosene = new FluidPneumaticCraft("kerosene");
    public static final Fluid diesel = new FluidPneumaticCraft("diesel");
    public static final Fluid lubricant = new FluidPneumaticCraft("lubricant");
    public static List<Fluid> fluids = new ArrayList<Fluid>();
    public static Map<Block, Item> fluidBlockToBucketMap = new HashMap<Block, Item>();
    private static Map<String, Block> fluidToBlockMap = new HashMap<String, Block>();

    public static void initFluids() {
        etchingAcid.setBlock((Block)new BlockFluidEtchingAcid());
        plastic.getBlock().func_149663_c(plastic.getName() + "Block");
        fluids.add(plastic);
        fluids.add(etchingAcid);
        fluids.add(lpg);
        fluids.add(gasoline);
        fluids.add(kerosene);
        fluids.add(diesel);
        fluids.add(oil);
        fluids.add(lubricant);
        Fluids.initializeFluidBlocksAndBuckets();
        PneumaticRegistry.getInstance().registerFuel(oil, 150000);
        PneumaticRegistry.getInstance().registerFuel(diesel, 700000);
        PneumaticRegistry.getInstance().registerFuel(kerosene, 1100000);
        PneumaticRegistry.getInstance().registerFuel(gasoline, 1500000);
        PneumaticRegistry.getInstance().registerFuel(lpg, 1800000);
        PneumaticCraft.instance.registerFuel(new ItemStack(Fluids.getBucket(oil)), 75000);
        PneumaticCraft.instance.registerFuel(new ItemStack(Fluids.getBucket(diesel)), 350000);
        PneumaticCraft.instance.registerFuel(new ItemStack(Fluids.getBucket(kerosene)), 550000);
        PneumaticCraft.instance.registerFuel(new ItemStack(Fluids.getBucket(gasoline)), 750000);
        PneumaticCraft.instance.registerFuel(new ItemStack(Fluids.getBucket(lpg)), 900000);
    }

    public static boolean areFluidsEqual(Fluid fluid1, Fluid fluid2) {
        if (fluid1 == null && fluid2 == null) {
            return true;
        }
        if (fluid1 == null != (fluid2 == null)) {
            return false;
        }
        return fluid1.getName().equals(fluid2.getName());
    }

    public static Item getBucket(Fluid fluid) {
        return fluidBlockToBucketMap.get(Fluids.getBlock(fluid));
    }

    public static Block getBlock(Fluid fluid) {
        return fluidToBlockMap.get(fluid.getName());
    }

    private static void initializeFluidBlocksAndBuckets() {
        for (final Fluid fluid : fluids) {
            Block fluidBlock = fluid.getBlock();
            Blockss.registerBlock(fluidBlock);
            fluidToBlockMap.put(fluid.getName(), fluidBlock);
            Item fluidBucket = new ItemBucket(fluidBlock){

                public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
                    super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
                    ItemPneumatic.addTooltip(p_77624_1_, p_77624_2_, p_77624_3_);
                }

                @SideOnly(value=Side.CLIENT)
                public void func_150895_a(Item item, CreativeTabs creativeTab, List items) {
                    if (FluidRegistry.isFluidDefault((Fluid)fluid)) {
                        super.func_150895_a(item, creativeTab, items);
                    }
                }
            }.func_77642_a(Items.field_151133_ar).func_77637_a((CreativeTabs)PneumaticCraft.tabPneumaticCraft).func_111206_d("pneumaticcraft:" + fluid.getName() + "Bucket").func_77655_b(fluid.getName() + "Bucket");
            Itemss.registerItem(fluidBucket);
            fluidBlockToBucketMap.put(fluidBlock, fluidBucket);
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(fluid, 1000), (ItemStack)new ItemStack(fluidBucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
    }
}

