/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.proxy.CommonProxy;

public abstract class TubeModuleRedstoneReceiving
extends TubeModule {
    protected int redstoneLevel;

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.redstoneLevel = tag.func_74762_e("redstone");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("redstone", this.redstoneLevel);
    }

    @Override
    public void addInfo(List<String> curInfo) {
        curInfo.add("Applied redstone: " + EnumChatFormatting.WHITE + this.redstoneLevel);
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.redstoneLevel = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.dir != side && (!this.isInline() || side == this.dir.getOpposite())) continue;
            this.redstoneLevel = Math.max(this.redstoneLevel, this.pressureTube.world().func_72878_l(this.pressureTube.x() + side.offsetX, this.pressureTube.y() + side.offsetY, this.pressureTube.z() + side.offsetZ, side.ordinal()));
        }
    }

    public int getReceivingRedstoneLevel() {
        return this.redstoneLevel;
    }

    public float getThreshold() {
        return this.getThreshold(this.redstoneLevel);
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return CommonProxy.EnumGuiId.PRESSURE_MODULE;
    }

    @Override
    public void update() {
        if (this.upgraded && !this.advancedConfig && this.higherBound != this.lowerBound) {
            this.higherBound = this.lowerBound;
            if (!this.getTube().world().field_72995_K) {
                this.sendDescriptionPacket();
            }
        }
    }
}

