/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.common.block.tubes.IPneumaticPosProvider;
import pneumaticCraft.common.block.tubes.ISidedPart;
import pneumaticCraft.common.block.tubes.ModuleRegistrator;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketOpenTubeModuleGui;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.proxy.CommonProxy;

public abstract class TubeModule
implements ISidedPart {
    protected IPneumaticPosProvider pressureTube;
    protected ForgeDirection dir = ForgeDirection.UP;
    public AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[6];
    protected boolean upgraded;
    public float lowerBound = 7.5f;
    public float higherBound = 0.0f;
    public float maxValue = 30.0f;
    private boolean fake;
    public boolean advancedConfig;
    public boolean shouldDrop;

    public TubeModule() {
        double width = this.getWidth() / 2.0;
        double height = this.getHeight();
        this.boundingBoxes[0] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.375 - height), (double)(0.5 - width), (double)(0.5 + width), (double)0.375, (double)(0.5 + width));
        this.boundingBoxes[1] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)0.625, (double)(0.5 - width), (double)(0.5 + width), (double)(0.625 + height), (double)(0.5 + width));
        this.boundingBoxes[2] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.5 - width), (double)(0.375 - height), (double)(0.5 + width), (double)(0.5 + width), (double)0.375);
        this.boundingBoxes[3] = AxisAlignedBB.func_72330_a((double)(0.5 - width), (double)(0.5 - width), (double)0.625, (double)(0.5 + width), (double)(0.5 + width), (double)(0.625 + height));
        this.boundingBoxes[4] = AxisAlignedBB.func_72330_a((double)(0.375 - height), (double)(0.5 - width), (double)(0.5 - width), (double)0.375, (double)(0.5 + width), (double)(0.5 + width));
        this.boundingBoxes[5] = AxisAlignedBB.func_72330_a((double)0.625, (double)(0.5 - width), (double)(0.5 - width), (double)(0.625 + height), (double)(0.5 + width), (double)(0.5 + width));
    }

    public void markFake() {
        this.fake = true;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setTube(IPneumaticPosProvider pressureTube) {
        this.pressureTube = pressureTube;
    }

    public IPneumaticPosProvider getTube() {
        return this.pressureTube;
    }

    public double getWidth() {
        return 0.25;
    }

    protected double getHeight() {
        return 0.375;
    }

    public float getThreshold(int redstone) {
        double slope = (this.higherBound - this.lowerBound) / 15.0f;
        double threshold = (double)this.lowerBound + slope * (double)redstone;
        return (float)threshold;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.shouldDrop) {
            drops.add(new ItemStack(ModuleRegistrator.getModuleItem(this.getType())));
            if (this.upgraded) {
                drops.add(new ItemStack(Itemss.advancedPCB));
            }
        }
        return drops;
    }

    @Override
    public void setDirection(ForgeDirection dir) {
        this.dir = dir;
    }

    public ForgeDirection getDirection() {
        return this.dir;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.dir = ForgeDirection.getOrientation((int)nbt.func_74762_e("dir"));
        this.upgraded = nbt.func_74767_n("upgraded");
        this.lowerBound = nbt.func_74760_g("lowerBound");
        this.higherBound = nbt.func_74760_g("higherBound");
        this.advancedConfig = nbt.func_74764_b("advancedConfig") ? nbt.func_74767_n("advancedConfig") : true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dir", this.dir.ordinal());
        nbt.func_74757_a("upgraded", this.upgraded);
        nbt.func_74776_a("lowerBound", this.lowerBound);
        nbt.func_74776_a("higherBound", this.higherBound);
        nbt.func_74757_a("advancedConfig", this.advancedConfig);
    }

    @Optional.Method(modid="ForgeMultipart")
    public void writeDesc(MCDataOutput data) {
        data.writeInt(this.dir.ordinal());
    }

    @Optional.Method(modid="ForgeMultipart")
    public void readDesc(MCDataInput data) {
        this.dir = ForgeDirection.getOrientation((int)data.readInt());
    }

    public void update() {
    }

    public void onNeighborTileUpdate() {
    }

    public void onNeighborBlockUpdate() {
    }

    public abstract String getType();

    public void renderDynamic(double x, double y, double z, float partialTicks, int renderPass, boolean itemRender) {
        if (renderPass == 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.getModel().getModelTexture(null));
            PneumaticCraftUtils.rotateMatrixByMetadata(this.dir.ordinal());
            this.renderModule();
            this.getModel().renderStatic(0.0625f, null);
            this.getModel().renderDynamic(0.0625f, null, partialTicks);
            GL11.glPopMatrix();
        }
    }

    protected void renderModule() {
    }

    public abstract IBaseModel getModel();

    public int getRedstoneLevel() {
        return 0;
    }

    protected void updateNeighbors() {
        this.pressureTube.world().func_147459_d(this.pressureTube.x(), this.pressureTube.y(), this.pressureTube.z(), this.pressureTube.world().func_147439_a(this.pressureTube.x(), this.pressureTube.y(), this.pressureTube.z()));
    }

    public boolean isInline() {
        return false;
    }

    public void sendDescriptionPacket() {
        ModInteractionUtils.getInstance().sendDescriptionPacket(this.pressureTube);
    }

    public void addInfo(List<String> curInfo) {
    }

    public void addItemDescription(List<String> curInfo) {
    }

    public boolean canUpgrade() {
        return true;
    }

    public void upgrade() {
        this.upgraded = true;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public boolean onActivated(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.upgraded && this.getGuiId() != null) {
            NetworkHandler.sendTo(new PacketOpenTubeModuleGui(this.getGuiId().ordinal(), this.pressureTube.x(), this.pressureTube.y(), this.pressureTube.z()), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    protected abstract CommonProxy.EnumGuiId getGuiId();
}

