/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.BlockElevatorFrame;
import pneumaticCraft.common.block.BlockPneumaticCraft;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.tileentity.TileEntityElevatorBase;
import pneumaticCraft.common.tileentity.TileEntityElevatorCaller;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class BlockElevatorCaller
extends BlockPneumaticCraft {
    protected BlockElevatorCaller(Material par2Material) {
        super(par2Material);
        this.func_149658_d("pneumaticcraft:ElevatorCaller");
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityElevatorCaller.class;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityElevatorCaller te = (TileEntityElevatorCaller)world.func_147438_o(x, y, z);
        if (!world.field_72995_K) {
            MovingObjectPosition mop = PneumaticCraftUtils.getEntityLookedObject((EntityLivingBase)player);
            if (mop != null && mop.subHit >= 0) {
                this.setSurroundingElevators(world, x, y, z, mop.subHit);
            } else if (player.func_70093_af()) {
                te.camoStack = player.func_71045_bC();
                return te.camoStack != null && te.camoStack.func_77973_b() instanceof ItemBlock;
            }
        }
        return te.getRotation().getOpposite().ordinal() == side;
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEntity te;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        MovingObjectPosition rayTrace = super.func_149731_a(world, x, y, z, origin, direction);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)(world.func_72805_g(x, y, z) & 7)).getOpposite();
        if (rayTrace != null && rayTrace.field_72310_e == orientation.ordinal() && (te = world.func_147438_o(x, y, z)) instanceof TileEntityElevatorCaller) {
            TileEntityElevatorCaller caller = (TileEntityElevatorCaller)te;
            for (TileEntityElevatorCaller.ElevatorButton button : caller.getFloors()) {
                float startX = 0.0f;
                float startZ = 0.0f;
                float endX = 0.0f;
                float endZ = 0.0f;
                switch (orientation) {
                    case NORTH: {
                        startZ = 0.0f;
                        endZ = 0.01f;
                        endX = 1.0f - (float)button.posX;
                        startX = 1.0f - ((float)button.posX + (float)button.width);
                        break;
                    }
                    case SOUTH: {
                        startZ = 0.99f;
                        endZ = 1.0f;
                        startX = (float)button.posX;
                        endX = (float)button.posX + (float)button.width;
                        break;
                    }
                    case WEST: {
                        startX = 0.0f;
                        endX = 0.01f;
                        startZ = (float)button.posX;
                        endZ = (float)button.posX + (float)button.width;
                        break;
                    }
                    case EAST: {
                        startX = 0.99f;
                        endX = 1.0f;
                        endZ = 1.0f - (float)button.posX;
                        startZ = 1.0f - ((float)button.posX + (float)button.width);
                    }
                }
                this.func_149676_a(startX, 1.0f - (float)(button.posY + button.height), startZ, endX, 1.0f - (float)button.posY, endZ);
                MovingObjectPosition buttonTrace = super.func_149731_a(world, x, y, z, origin, direction);
                if (buttonTrace == null) continue;
                if (startX > 0.01f && startX < 0.98f) {
                    startX += 0.01f;
                }
                if (startZ > 0.01f && startZ < 0.98f) {
                    startZ += 0.01f;
                }
                if (endX > 0.02f && endX < 0.99f) {
                    endX -= 0.01f;
                }
                if (endZ > 0.02f && endZ < 0.99f) {
                    endZ -= 0.01f;
                }
                this.func_149676_a(startX, 1.01f - (float)(button.posY + button.height), startZ, endX, 0.99f - (float)button.posY, endZ);
                buttonTrace.subHit = button.floorNumber;
                return buttonTrace;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return rayTrace;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int oldMeta = world.func_72805_g(x, y, z);
        boolean wasPowered = oldMeta / 8 > 0;
        boolean isPowered = world.func_72864_z(x, y, z);
        if (!wasPowered && isPowered) {
            world.func_72921_c(x, y, z, oldMeta + 8, 3);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityElevatorCaller) {
                this.setSurroundingElevators(world, x, y, z, ((TileEntityElevatorCaller)te).thisFloor);
            }
        } else if (wasPowered && !isPowered) {
            world.func_72921_c(x, y, z, oldMeta - 8, 3);
        }
    }

    private void setSurroundingElevators(World world, int x, int y, int z, int floor) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityElevatorBase elevator;
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || (elevator = this.getElevatorBase(world, x + dir.offsetX, y - 2, z + dir.offsetZ)) == null) continue;
            elevator.goToFloor(floor);
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        this.updateElevatorButtons(world, x, y, z);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.updateElevatorButtons(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private void updateElevatorButtons(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityElevatorBase elevator;
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || (elevator = this.getElevatorBase(world, x + dir.offsetX, y - 2, z + dir.offsetZ)) == null) continue;
            elevator.updateFloors();
        }
    }

    private TileEntityElevatorBase getElevatorBase(World world, int x, int y, int z) {
        TileEntity te;
        Block block = world.func_147439_a(x, y, z);
        TileEntityElevatorBase elevator = null;
        if (block == Blockss.elevatorFrame) {
            elevator = BlockElevatorFrame.getElevatorTE((IBlockAccess)world, x, y, z);
        }
        if (block == Blockss.elevatorBase && (te = world.func_147438_o(x, y, z)) instanceof TileEntityElevatorBase && ((TileEntityElevatorBase)te).isCoreElevator()) {
            elevator = (TileEntityElevatorBase)te;
        }
        return elevator;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        this.func_149683_g();
        return super.func_149645_b();
    }

    public boolean func_149744_f() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityElevatorCaller te = (TileEntityElevatorCaller)world.func_147438_o(x, y, z);
        if (te.camoBlock != null && PneumaticCraftUtils.isRenderIDCamo(te.camoBlock.func_149645_b())) {
            return te.camoBlock.func_149691_a(side, te.camoStack.func_77960_j());
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntity te = par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (te instanceof TileEntityElevatorCaller) {
            TileEntityElevatorCaller teEc = (TileEntityElevatorCaller)te;
            return teEc.getEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }
}

