/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinderDrone;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pneumaticCraft.api.drone.IPathNavigator;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketPlaySound;
import pneumaticCraft.common.network.PacketSpawnParticle;

public class EntityPathNavigateDrone
extends PathNavigate
implements IPathNavigator {
    private final EntityDrone pathfindingEntity;
    public boolean pathThroughLiquid;
    private boolean forceTeleport;
    private int teleportCounter = -1;
    private int telX;
    private int telY;
    private int telZ;
    private static final int TELEPORT_TICKS = 120;

    public EntityPathNavigateDrone(EntityDrone pathfindingEntity, World par2World) {
        super((EntityLiving)pathfindingEntity, par2World);
        this.pathfindingEntity = pathfindingEntity;
    }

    public boolean func_75497_a(Entity p_75497_1_, double p_75497_2_) {
        return super.func_75497_a(p_75497_1_, p_75497_2_) || this.isGoingToTeleport();
    }

    public PathEntity func_75488_a(double par1, double par3, double par5) {
        return this.getEntityPathToXYZ(this.pathfindingEntity, MathHelper.func_76128_c((double)par1), (int)par3, MathHelper.func_76128_c((double)par5), this.func_111269_d(), false, false, true, false);
    }

    public PathEntity func_75494_a(Entity par1Entity) {
        return this.getPathEntityToEntity(this.pathfindingEntity, par1Entity, this.func_111269_d(), false, false, true, false);
    }

    public void setForceTeleport(boolean forceTeleport) {
        this.forceTeleport = forceTeleport;
    }

    private PathEntity getPathEntityToEntity(EntityDrone par1Entity, Entity par2Entity, float par3, boolean par4, boolean par5, boolean par6, boolean par7) {
        return this.getEntityPathToXYZ(par1Entity, (int)Math.floor(par2Entity.field_70165_t), (int)Math.floor(par2Entity.field_70163_u), (int)Math.floor(par2Entity.field_70161_v), par3, par4, par5, par6, par7);
    }

    public PathEntity getEntityPathToXYZ(EntityDrone par1Entity, int par2, int par3, int par4, float par5, boolean par6, boolean par7, boolean par8, boolean par9) {
        PathPoint finalPoint;
        int i3;
        int l2;
        int k2;
        int j2;
        int i2;
        int k1;
        int l1;
        ChunkCache chunkcache;
        if (!par1Entity.isBlockValidPathfindBlock(par2, par3, par4)) {
            return null;
        }
        PathEntity pathentity = null;
        int l = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)par1Entity.field_70163_u);
        int j1 = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        if (!(this.forceTeleport && (l != par2 || i1 != par3 || j1 != par4) || (pathentity = new PathFinderDrone(par1Entity, (IBlockAccess)(chunkcache = new ChunkCache(par1Entity.field_70170_p, l1 = l - (k1 = (int)(par5 + 8.0f)), i2 = i1 - k1, j2 = j1 - k1, k2 = l + k1, l2 = i1 + k1, i3 = j1 + k1, 0)), par6, par7, this.pathThroughLiquid, par9).createEntityPathTo((Entity)par1Entity, par2, par3, par4, par5)) == null || (finalPoint = pathentity.func_75870_c()) != null && finalPoint.field_75839_a == par2 && finalPoint.field_75837_b == par3 && finalPoint.field_75838_c == par4)) {
            pathentity = null;
        }
        this.teleportCounter = pathentity != null ? -1 : 0;
        this.telX = par2;
        this.telY = par3;
        this.telZ = par4;
        par1Entity.setStandby(false);
        return pathentity;
    }

    public float func_111269_d() {
        return (float)this.pathfindingEntity.getRange();
    }

    @Override
    public boolean isGoingToTeleport() {
        return this.teleportCounter >= 0;
    }

    public boolean func_75500_f() {
        return super.func_75500_f() && !this.isGoingToTeleport();
    }

    public void func_75501_e() {
        if (this.isGoingToTeleport()) {
            if (this.teleportCounter == 0 || this.teleportCounter == 60) {
                NetworkHandler.sendToAllAround(new PacketPlaySound("pneumaticcraft:hudInit", this.pathfindingEntity.field_70165_t, this.pathfindingEntity.field_70163_u, this.pathfindingEntity.field_70161_v, 0.1f, this.teleportCounter == 0 ? 0.7f : 1.0f, true), this.pathfindingEntity.field_70170_p);
            }
            if (this.teleportCounter < 80) {
                Random rand = this.pathfindingEntity.func_70681_au();
                float f = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f1 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f2 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle("portal", this.pathfindingEntity.field_70165_t, this.pathfindingEntity.field_70163_u, this.pathfindingEntity.field_70161_v, f, f1, f2), this.pathfindingEntity.field_70170_p);
            }
            if (++this.teleportCounter > 120) {
                if (this.pathfindingEntity.isBlockValidPathfindBlock(this.telX, this.telY, this.telZ)) {
                    this.teleport();
                }
                this.teleportCounter = -1;
                this.func_75484_a(null, 0.0);
                this.pathfindingEntity.func_70605_aq().func_75642_a((double)this.telX, (double)this.telY, (double)this.telZ, this.pathfindingEntity.getSpeed());
                this.pathfindingEntity.addAir(null, -10000);
            }
        } else {
            super.func_75501_e();
        }
    }

    public void teleport() {
        Random rand = this.pathfindingEntity.func_70681_au();
        double width = this.pathfindingEntity.field_70130_N;
        double height = this.pathfindingEntity.field_70131_O;
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = this.pathfindingEntity.field_70165_t + ((double)this.telX + 0.5 - this.pathfindingEntity.field_70165_t) * d6 + (rand.nextDouble() - 0.5) * width * 2.0;
            double d8 = this.pathfindingEntity.field_70163_u + ((double)this.telY - this.pathfindingEntity.field_70163_u) * d6 + rand.nextDouble() * height;
            double d9 = this.pathfindingEntity.field_70161_v + ((double)this.telZ + 0.5 - this.pathfindingEntity.field_70161_v) * d6 + (rand.nextDouble() - 0.5) * width * 2.0;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle("portal", d7, d8, d9, f, f1, f2), this.pathfindingEntity.field_70170_p);
        }
        this.pathfindingEntity.field_70170_p.func_72908_a(this.pathfindingEntity.field_70165_t, this.pathfindingEntity.field_70163_u, this.pathfindingEntity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        this.pathfindingEntity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        this.pathfindingEntity.func_70107_b((double)this.telX + 0.5, (double)this.telY + 0.5, (double)this.telZ + 0.5);
    }

    @Override
    public boolean moveToXYZ(double x, double y, double z) {
        return this.func_75492_a(x, y, z, this.pathfindingEntity.getSpeed());
    }

    @Override
    public boolean moveToEntity(Entity entity) {
        return this.func_75497_a(entity, this.pathfindingEntity.getSpeed());
    }

    @Override
    public boolean hasNoPath() {
        return this.func_75500_f();
    }

    public boolean func_75493_a(Vec3 p_75493_1_, Vec3 p_75493_2_, int p_75493_3_, int p_75493_4_, int p_75493_5_) {
        return false;
    }
}

