/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import pneumaticCraft.common.EventHandlerPneumaticCraft;
import pneumaticCraft.common.ai.DistanceEntitySorter;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class DroneEntityAIPickupItems
extends EntityAIBase {
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase itemPickupWidget;
    private EntityItem curPickingUpEntity;
    private final DistanceEntitySorter theNearestAttackableTargetSorter;

    public DroneEntityAIPickupItems(IDroneBase drone, ProgWidgetAreaItemBase progWidgetPickupItem) {
        this.drone = drone;
        this.func_75248_a(63);
        this.itemPickupWidget = progWidgetPickupItem;
        this.theNearestAttackableTargetSorter = new DistanceEntitySorter(drone);
    }

    public boolean func_75250_a() {
        List<Entity> pickableItems = this.itemPickupWidget.getEntitiesInArea(this.drone.getWorld(), new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity instanceof EntityItem && entity.func_70089_S();
            }
        });
        Collections.sort(pickableItems, this.theNearestAttackableTargetSorter);
        for (Entity ent : pickableItems) {
            ItemStack stack = ((EntityItem)ent).func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                    ItemStack droneStack = this.drone.getInventory().func_70301_a(i);
                    if (droneStack != null && (!droneStack.func_77969_a(stack) || droneStack.field_77994_a >= droneStack.func_77976_d()) || !this.drone.getPathNavigator().moveToEntity(ent)) continue;
                    this.curPickingUpEntity = (EntityItem)ent;
                    return true;
                }
                continue;
            }
            this.drone.addDebugEntry("gui.progWidget.itemPickup.debug.itemNotValid");
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.curPickingUpEntity.field_70128_L) {
            return false;
        }
        if (Vec3.func_72443_a((double)this.curPickingUpEntity.field_70165_t, (double)this.curPickingUpEntity.field_70163_u, (double)this.curPickingUpEntity.field_70161_v).func_72438_d(this.drone.getPosition()) < 1.5) {
            ItemStack stack = this.curPickingUpEntity.func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                new EventHandlerPneumaticCraft().onPlayerPickup(new EntityItemPickupEvent((EntityPlayer)this.drone.getFakePlayer(), this.curPickingUpEntity));
                int stackSize = stack.field_77994_a;
                ItemStack remainder = PneumaticCraftUtils.exportStackToInventory(this.drone.getInventory(), stack, ForgeDirection.UP);
                if (remainder == null) {
                    this.drone.onItemPickupEvent(this.curPickingUpEntity, stackSize);
                    this.curPickingUpEntity.func_70106_y();
                }
            }
            return false;
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }
}

