/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.lib.Log;
import pneumaticCraft.lib.Versions;

public class UpdateChecker
extends Thread {
    private static UpdateChecker INSTANCE = new UpdateChecker();
    private final String url = "http://www.minemaarten.com/downloads/pneumaticcraft-changelog/pneumaticcraft-";
    private boolean doneChecking;
    private boolean hasNewVersion;
    private final List<String> additions = new ArrayList<String>();
    private final List<String> apiChanges = new ArrayList<String>();
    private final List<String> bugfixes = new ArrayList<String>();
    private String latestVersion;
    private String updateSize;
    private int displayDelay = 200;

    public static UpdateChecker instance() {
        return INSTANCE;
    }

    @Override
    public void run() {
        this.checkForUpdate();
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K) {
            if (this.displayDelay > 0) {
                --this.displayDelay;
            }
            if (this.doneChecking && this.displayDelay == 0) {
                if (this.hasNewVersion) {
                    UpdateChecker.sendMessage((ICommandSender)event.player, "There's a new " + this.updateSize + " version of PneumaticCraft available: version " + this.latestVersion + " (you are running " + Versions.fullVersionString() + ").");
                    UpdateChecker.sendMessage((ICommandSender)event.player, "Use '/pc changelog' to see what has changed.");
                }
                FMLCommonHandler.instance().bus().unregister((Object)this);
            }
        }
    }

    private static void sendMessage(ICommandSender player, List<String> message) {
        for (String s : message) {
            UpdateChecker.sendMessage(player, s);
        }
    }

    private static void sendMessage(ICommandSender player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
    }

    private void checkForUpdate() {
        int versionNumbers = 3;
        this.latestVersion = Versions.fullVersionString();
        int changeSize = 10000;
        try {
            UpdateChecker.getPage("http://www.minemaarten.com/downloads/pneumaticcraft-changelog/pneumaticcraft-" + this.latestVersion.replace('.', '-') + "/");
            int curDigit = versionNumbers - 1;
            while (curDigit >= 0) {
                try {
                    String checkingVersion = this.incVersion(this.latestVersion, curDigit);
                    String totalText = UpdateChecker.getPage("http://www.minemaarten.com/downloads/pneumaticcraft-changelog/pneumaticcraft-" + checkingVersion.replace('.', '-') + "/");
                    if (totalText.contains("It looks like nothing was found at this location. Maybe try a search?")) {
                        --curDigit;
                        continue;
                    }
                    String[] text = totalText.replace("<br />", "").replace("<p>", "").replace("</p>", "").replace("\t", "").replace("</a>", "").replace("&#8217;", "'").replace("&#8216;", "'").replace("&#8230;", "...").split(System.getProperty("line.separator"));
                    boolean parsingContent = false;
                    for (String line : text) {
                        if (line.contains("entry-content")) {
                            if (parsingContent) break;
                            parsingContent = true;
                            continue;
                        }
                        if (!parsingContent) continue;
                        if (line.startsWith("-Bugfix")) {
                            this.bugfixes.add(line);
                            continue;
                        }
                        if (line.startsWith("-API")) {
                            this.apiChanges.add(line);
                            continue;
                        }
                        this.additions.add(line);
                    }
                    this.latestVersion = checkingVersion;
                    changeSize = changeSize > curDigit ? curDigit : changeSize;
                    curDigit = versionNumbers - 1;
                }
                catch (IOException e) {
                    --curDigit;
                }
            }
            if (changeSize < 10000) {
                this.updateSize = (new String[]{"Massive", "Major", "Minor"})[changeSize];
                Log.info("New " + this.updateSize + " update available: " + this.latestVersion);
                this.hasNewVersion = true;
            } else {
                Log.info("Up to date!");
            }
            this.doneChecking = true;
        }
        catch (IOException e) {
            Log.error("The URL of the current version changed, the current running version is weirdly formatted (dev version?), minemaarten.com is down or there is a problem with your internet connection.");
        }
    }

    private String incVersion(String version, int digit) {
        int i;
        String[] numStrings = version.split("\\.");
        int[] nums = new int[numStrings.length];
        for (i = 0; i < nums.length; ++i) {
            nums[i] = Integer.parseInt(numStrings[i]);
        }
        int n = digit;
        nums[n] = nums[n] + 1;
        for (i = digit + 1; digit != 0 && i < nums.length; ++i) {
            nums[i] = 0;
        }
        String newVersion = Integer.toString(nums[0]);
        for (int i2 = 1; i2 < nums.length; ++i2) {
            newVersion = newVersion + "." + nums[i2];
        }
        return newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPage(String URL2) throws IOException {
        String line = "";
        String all = "";
        URL myUrl = null;
        BufferedReader in = null;
        try {
            myUrl = new URL(URL2);
            in = new BufferedReader(new InputStreamReader(myUrl.openStream()));
            while ((line = in.readLine()) != null) {
                all = all + line + System.getProperty("line.separator");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return all;
    }

    public static class CommandChangelog
    extends CommandBase {
        public String func_71517_b() {
            return "pc";
        }

        public int func_82362_a() {
            return -100;
        }

        public String func_71518_a(ICommandSender icommandsender) {
            return "/pc changelog [<additions/apichanges/bugfixes/true/false>]";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void func_71515_b(ICommandSender icommandsender, String[] astring) {
            if (astring.length <= 0 || !astring[0].equalsIgnoreCase("changelog")) throw new WrongUsageException(this.func_71518_a(icommandsender), new Object[0]);
            if (astring.length > 1) {
                if (astring[1].equalsIgnoreCase("additions")) {
                    if (UpdateChecker.instance().additions.size() > 0) {
                        UpdateChecker.sendMessage(icommandsender, "-----Additions-----");
                        UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().additions);
                        return;
                    } else {
                        UpdateChecker.sendMessage(icommandsender, "No additions in the newest PneumaticCraft. :(");
                    }
                    return;
                } else if (astring[1].equalsIgnoreCase("apichanges")) {
                    if (UpdateChecker.instance().apiChanges.size() > 0) {
                        UpdateChecker.sendMessage(icommandsender, "-----API Changes-----");
                        UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().apiChanges);
                        return;
                    } else {
                        UpdateChecker.sendMessage(icommandsender, "No API changes in the newest PneumaticCraft.");
                    }
                    return;
                } else if (astring[1].equalsIgnoreCase("bugfixes")) {
                    if (UpdateChecker.instance().bugfixes.size() > 0) {
                        UpdateChecker.sendMessage(icommandsender, "-----Bugfixes-----");
                        UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().bugfixes);
                        return;
                    } else {
                        UpdateChecker.sendMessage(icommandsender, "No bugfixes in the newest PneumaticCraft.");
                    }
                    return;
                } else if (astring[1].equalsIgnoreCase("true")) {
                    UpdateChecker.sendMessage(icommandsender, "You'll now get a notification when a new version of PneumaticCraft is released. Checking now...");
                    Config.config.get("general", "Enable Update Checker", true).set(true);
                    Config.config.save();
                    INSTANCE = new UpdateChecker();
                    UpdateChecker.instance().displayDelay = 0;
                    FMLCommonHandler.instance().bus().register((Object)UpdateChecker.instance());
                    UpdateChecker.instance().start();
                    Config.enableUpdateChecker = true;
                    return;
                } else {
                    if (!astring[1].equalsIgnoreCase("false")) throw new WrongUsageException(this.func_71518_a(icommandsender), new Object[0]);
                    UpdateChecker.sendMessage(icommandsender, "You'll no longer get a notification when there's a new version of PneumaticCraft available.");
                    Config.config.get("general", "Enable Update Checker", true).set(false);
                    Config.config.save();
                    Config.enableUpdateChecker = false;
                }
                return;
            } else {
                if (UpdateChecker.instance().additions.size() > 0) {
                    UpdateChecker.sendMessage(icommandsender, "-----Additions-----");
                    UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().additions);
                }
                if (UpdateChecker.instance().apiChanges.size() > 0) {
                    UpdateChecker.sendMessage(icommandsender, "-----API Changes-----");
                    UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().apiChanges);
                }
                if (UpdateChecker.instance().bugfixes.size() <= 0) return;
                UpdateChecker.sendMessage(icommandsender, "-----Bugfixes-----");
                UpdateChecker.sendMessage(icommandsender, UpdateChecker.instance().bugfixes);
            }
        }
    }
}

