/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor.hacking;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableBlock;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableEntity;
import pneumaticCraft.client.render.pneumaticArmor.BlockTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.EntityTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.client.render.pneumaticArmor.RenderBlockTarget;
import pneumaticCraft.client.render.pneumaticArmor.RenderTarget;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableButton;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableDispenser;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableDoor;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableJukebox;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableLever;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableMobSpawner;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableNoteblock;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableSecurityStation;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableTNT;
import pneumaticCraft.client.render.pneumaticArmor.hacking.block.HackableTripwire;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableBat;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableBlaze;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableCaveSpider;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableCow;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableCreeper;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableEnderman;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableGhast;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableLivingDisarm;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableTameable;
import pneumaticCraft.client.render.pneumaticArmor.hacking.entity.HackableWitch;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.util.WorldAndCoord;
import pneumaticCraft.lib.Log;

public class HackableHandler {
    private final Map<Entity, IHackableEntity> trackedHackableEntities = new HashMap<Entity, IHackableEntity>();
    private final Map<WorldAndCoord, IHackableBlock> trackedHackableBlocks = new HashMap<WorldAndCoord, IHackableBlock>();
    private static HackableHandler clientInstance;
    private static HackableHandler serverInstance;

    private static HackableHandler getInstance() {
        if (PneumaticCraft.proxy.getSide() == Side.CLIENT) {
            if (clientInstance == null) {
                clientInstance = new HackableHandler();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackableHandler();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150335_W, HackableTNT.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150474_ac, HackableMobSpawner.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150442_at, HackableLever.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150430_aB, HackableButton.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150471_bO, HackableButton.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150466_ao, HackableDoor.class);
        PneumaticRegistry.getInstance().addHackable((Block)Blocks.field_150479_bC, HackableTripwire.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150367_z, HackableDispenser.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150409_cd, HackableDispenser.class);
        PneumaticRegistry.getInstance().addHackable(Blockss.securityStation, HackableSecurityStation.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150418_aU, HackableTripwire.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150323_B, HackableNoteblock.class);
        PneumaticRegistry.getInstance().addHackable(Blocks.field_150421_aI, HackableJukebox.class);
        PneumaticRegistry.getInstance().addHackable(EntityCreeper.class, HackableCreeper.class);
        PneumaticRegistry.getInstance().addHackable(EntityTameable.class, HackableTameable.class);
        PneumaticRegistry.getInstance().addHackable(EntityCow.class, HackableCow.class);
        PneumaticRegistry.getInstance().addHackable(EntityCaveSpider.class, HackableCaveSpider.class);
        PneumaticRegistry.getInstance().addHackable(EntityBlaze.class, HackableBlaze.class);
        PneumaticRegistry.getInstance().addHackable(EntityGhast.class, HackableGhast.class);
        PneumaticRegistry.getInstance().addHackable(EntityWitch.class, HackableWitch.class);
        PneumaticRegistry.getInstance().addHackable(EntityLiving.class, HackableLivingDisarm.class);
        PneumaticRegistry.getInstance().addHackable(EntityEnderman.class, HackableEnderman.class);
        PneumaticRegistry.getInstance().addHackable(EntityBat.class, HackableBat.class);
    }

    public static IHackableEntity getHackableForEntity(Entity entity, EntityPlayer player) {
        Iterator<Map.Entry<Entity, IHackableEntity>> iterator = HackableHandler.getInstance().trackedHackableEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, IHackableEntity> entry = iterator.next();
            if (!entry.getKey().field_70128_L && (entry.getValue().canHack(entry.getKey(), player) || HackableHandler.isInDisplayCooldown(entry.getValue(), entry.getKey()))) continue;
            iterator.remove();
        }
        if (entity instanceof IHackableEntity && ((IHackableEntity)entity).canHack(entity, player)) {
            return (IHackableEntity)entity;
        }
        IHackableEntity hackable = HackableHandler.getInstance().trackedHackableEntities.get(entity);
        if (hackable == null) {
            for (Map.Entry<Class<? extends Entity>, Class<? extends IHackableEntity>> entry : PneumaticCraftAPIHandler.getInstance().hackableEntities.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
                try {
                    hackable = entry.getValue().newInstance();
                    if (hackable.canHack(entity, player)) {
                        HackableHandler.getInstance().trackedHackableEntities.put(entity, hackable);
                        break;
                    }
                    hackable = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return hackable;
    }

    public static IHackableBlock getHackableForCoord(WorldAndCoord coord, EntityPlayer player) {
        return HackableHandler.getHackableForCoord(coord.world, coord.x, coord.y, coord.z, player);
    }

    public static IHackableBlock getHackableForCoord(IBlockAccess world, int x, int y, int z, EntityPlayer player) {
        Iterator<Map.Entry<WorldAndCoord, IHackableBlock>> iterator = HackableHandler.getInstance().trackedHackableBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WorldAndCoord, IHackableBlock> entry = iterator.next();
            Class<? extends IHackableBlock> hackableBlockClazz = PneumaticCraftAPIHandler.getInstance().hackableBlocks.get(entry.getKey().getBlock());
            if (hackableBlockClazz == entry.getValue().getClass() && (entry.getValue().canHack(entry.getKey().world, entry.getKey().x, entry.getKey().y, entry.getKey().z, player) || HackableHandler.isInDisplayCooldown(entry.getValue(), entry.getKey().world, entry.getKey().x, entry.getKey().y, entry.getKey().z, player))) continue;
            iterator.remove();
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IHackableBlock && ((IHackableBlock)block).canHack(world, x, y, z, player)) {
            return (IHackableBlock)block;
        }
        IHackableBlock hackable = HackableHandler.getInstance().trackedHackableBlocks.get(new WorldAndCoord(world, x, y, z));
        if (hackable == null) {
            if (!PneumaticCraftAPIHandler.getInstance().hackableBlocks.containsKey(block)) {
                return null;
            }
            try {
                hackable = PneumaticCraftAPIHandler.getInstance().hackableBlocks.get(block).newInstance();
                if (hackable.canHack(world, x, y, z, player)) {
                    HackableHandler.getInstance().trackedHackableBlocks.put(new WorldAndCoord(world, x, y, z), hackable);
                } else {
                    hackable = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hackable;
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, IBlockAccess world, int x, int y, int z, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            RenderBlockTarget target = HUDHandler.instance().getSpecificRenderer(BlockTrackUpgradeHandler.class).getTargetForCoord(x, y, z);
            int requiredHackTime = hackableBlock.getHackTime(world, x, y, z, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity hackableBlock, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            RenderTarget target = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableBlock.getHackTime(entity, PneumaticCraft.proxy.getPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    public static void onEntityConstruction(Entity entity) {
        entity.registerExtendedProperties("PneumaticCraftHacking", (IExtendedEntityProperties)new HackingEntityProperties());
    }

    public static class HackingEntityProperties
    implements IExtendedEntityProperties {
        private List<IHackableEntity> hackables;

        public void saveNBTData(NBTTagCompound compound) {
            if (this.hackables != null && !this.hackables.isEmpty()) {
                NBTTagList tagList = new NBTTagList();
                for (IHackableEntity hackableEntity : this.hackables) {
                    if (hackableEntity.getId() == null) continue;
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("id", hackableEntity.getId());
                    tagList.func_74742_a((NBTBase)tag);
                }
                compound.func_74782_a("hackables", (NBTBase)tagList);
            }
        }

        public void loadNBTData(NBTTagCompound compound) {
            this.hackables = null;
            NBTTagList tagList = compound.func_150295_c("hackables", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String hackableId = tagList.func_150305_b(i).func_74779_i("id");
                Class<? extends IHackableEntity> hackableClass = PneumaticCraftAPIHandler.getInstance().stringToEntityHackables.get(hackableId);
                if (hackableClass != null) {
                    try {
                        if (this.hackables == null) {
                            this.hackables = new ArrayList<IHackableEntity>();
                        }
                        this.hackables.add(hackableClass.newInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Log.warning("hackable \"" + hackableId + "\" not found when constructing from nbt. Was it deleted?");
            }
        }

        public void init(Entity entity, World world) {
        }

        public void update(Entity entity) {
            if (this.hackables != null) {
                Iterator<IHackableEntity> iterator = this.hackables.iterator();
                while (iterator.hasNext()) {
                    IHackableEntity hackable = iterator.next();
                    if (hackable.afterHackTick(entity)) continue;
                    iterator.remove();
                }
            }
        }

        public void addHackable(IHackableEntity hackable) {
            if (this.hackables == null) {
                this.hackables = new ArrayList<IHackableEntity>();
            }
            this.hackables.add(hackable);
        }

        public List<IHackableEntity> getCurrentHacks() {
            return this.hackables;
        }
    }
}

