/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor.blockTracker;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import pneumaticCraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import pneumaticCraft.api.client.pneumaticHelmet.InventoryTrackEvent;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketDescriptionPacketRequest;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class BlockTrackEntryInventory
implements IBlockTrackEntry {
    public static Map tileEntityClassToNameMapping;
    private static List<String> invBlackList;

    public static void addTileEntityToBlackList(TileEntity te, Throwable e) {
        e.printStackTrace();
        String title = te.func_145831_w().func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e).func_149732_F();
        HUDHandler.instance().addMessage("Block tracking failed for " + title + "! A stacktrace can be found in the log.", new ArrayList<String>(), 60, -65536);
        invBlackList.add((String)tileEntityClassToNameMapping.get(te.getClass()));
    }

    @Override
    public boolean shouldTrackWithThisEntry(IBlockAccess world, int x, int y, int z, Block block, TileEntity te) {
        if (tileEntityClassToNameMapping == null) {
            try {
                tileEntityClassToNameMapping = (Map)ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"field_145853_j", "classToNameMap"}).get(null);
            }
            catch (Exception e) {
                Log.error("[BlockTrackEntryInventory.class] Uhm reflection failed here!");
                e.printStackTrace();
            }
        }
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (chest.field_145991_k != null || chest.field_145992_i != null) {
                return false;
            }
        }
        return te != null && !invBlackList.contains(tileEntityClassToNameMapping.get(te.getClass())) && te instanceof IInventory && ((IInventory)te).func_70302_i_() > 0 && !MinecraftForge.EVENT_BUS.post((Event)new InventoryTrackEvent(te));
    }

    @Override
    public boolean shouldBeUpdatedFromServer(TileEntity te) {
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (chest.field_145990_j != null) {
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(chest.field_145990_j.field_145851_c, chest.field_145990_j.field_145848_d, chest.field_145990_j.field_145849_e));
            }
            if (chest.field_145988_l != null) {
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(chest.field_145988_l.field_145851_c, chest.field_145988_l.field_145848_d, chest.field_145988_l.field_145849_e));
            }
        }
        return true;
    }

    @Override
    public int spamThreshold() {
        return 6;
    }

    @Override
    public void addInformation(World world, int x, int y, int z, TileEntity te, List<String> infoList) {
        try {
            IInventory inventory = IOHelper.getInventoryForTE(te);
            if (inventory != null) {
                boolean empty = true;
                ItemStack[] inventoryStacks = new ItemStack[inventory.func_70302_i_()];
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack iStack = inventory.func_70301_a(i);
                    if (iStack != null) {
                        empty = false;
                    }
                    inventoryStacks[i] = iStack;
                }
                if (empty) {
                    infoList.add("Contents: Empty");
                } else {
                    infoList.add("Contents:");
                    PneumaticCraftUtils.sortCombineItemStacksAndToString(infoList, inventoryStacks);
                }
            }
        }
        catch (Throwable e) {
            BlockTrackEntryInventory.addTileEntityToBlackList(te, e);
        }
    }

    @Override
    public String getEntryName() {
        return "blockTracker.module.inventories";
    }

    static {
        invBlackList = new ArrayList<String>();
    }
}

