/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.api.client.pneumaticHelmet.RenderHandlerRegistry;
import pneumaticCraft.client.render.pneumaticArmor.BlockTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.CoordTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.DroneDebugUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.EntityTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.MainHelmetHandler;
import pneumaticCraft.client.render.pneumaticArmor.SearchUpgradeHandler;
import pneumaticCraft.common.CommonHUDHandler;

public class UpgradeRenderHandlerList {
    private static UpgradeRenderHandlerList INSTANCE;
    public final List<IUpgradeRenderHandler> upgradeRenderers = new ArrayList<IUpgradeRenderHandler>();

    public static UpgradeRenderHandlerList instance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new UpgradeRenderHandlerList();
    }

    private UpgradeRenderHandlerList() {
        RenderHandlerRegistry.renderHandlers = this.upgradeRenderers;
        this.upgradeRenderers.add(new MainHelmetHandler());
        this.upgradeRenderers.add(new BlockTrackUpgradeHandler());
        this.upgradeRenderers.add(new EntityTrackUpgradeHandler());
        this.upgradeRenderers.add(new SearchUpgradeHandler());
        this.upgradeRenderers.add(new CoordTrackUpgradeHandler());
        this.upgradeRenderers.add(new DroneDebugUpgradeHandler());
    }

    public float getAirUsage(EntityPlayer player, boolean countDisabled) {
        float totalUsage = 0.0f;
        for (int i = 0; i < this.upgradeRenderers.size(); ++i) {
            if (!CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).upgradeRenderersInserted[i] || !countDisabled && !CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).upgradeRenderersEnabled[i]) continue;
            totalUsage += this.upgradeRenderers.get(i).getEnergyUsage(CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).rangeUpgradesInstalled, player);
        }
        return totalUsage;
    }
}

