/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.render.pneumaticArmor.RenderCoordWireframe;
import pneumaticCraft.common.entity.living.EntityDrone;

public class RenderDroneAI {
    private final EntityDrone drone;
    private final RenderItem renderItem;
    private final EntityItem entityItem;
    private final List<Pair<RenderCoordWireframe, Integer>> blackListWireframes = new ArrayList<Pair<RenderCoordWireframe, Integer>>();
    private float progress = 0.0f;
    private ChunkPosition oldPos;
    private ChunkPosition pos;

    public RenderDroneAI(EntityDrone drone) {
        this.drone = drone;
        this.renderItem = new RenderItem();
        this.renderItem.func_76976_a(RenderManager.field_78727_a);
        this.entityItem = new EntityItem(drone.field_70170_p);
        this.update();
    }

    public void update() {
        this.entityItem.field_70292_b += 4;
        ChunkPosition lastPos = this.pos;
        this.pos = this.drone.getTargetedBlock();
        if (this.pos != null) {
            if (lastPos == null) {
                this.oldPos = this.pos;
            } else if (!this.pos.equals((Object)lastPos)) {
                this.progress = 0.0f;
                this.oldPos = lastPos;
            }
        } else {
            this.oldPos = null;
        }
        this.progress = Math.min((float)Math.PI, this.progress + 0.1f);
        Iterator<Pair<RenderCoordWireframe, Integer>> iterator = this.blackListWireframes.iterator();
        while (iterator.hasNext()) {
            Pair<RenderCoordWireframe, Integer> wireframe = iterator.next();
            ++((RenderCoordWireframe)wireframe.getKey()).ticksExisted;
            wireframe.setValue((Object)((Integer)wireframe.getValue() - 1));
            if ((Integer)wireframe.getValue() > 0) continue;
            iterator.remove();
        }
    }

    public void render(float partialTicks) {
        for (Pair<RenderCoordWireframe, Integer> wireframe : this.blackListWireframes) {
            ((RenderCoordWireframe)wireframe.getKey()).render(partialTicks);
        }
        ItemStack activeProgram = this.drone.getActiveProgram();
        if (activeProgram != null && this.pos != null) {
            this.entityItem.func_92058_a(activeProgram);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glEnable((int)3553);
            this.renderItem.func_76986_a(this.entityItem, this.getInterpolated(this.pos.field_151329_a, this.oldPos.field_151329_a, partialTicks) + 0.5, this.getInterpolated(this.pos.field_151327_b, this.oldPos.field_151327_b, partialTicks) + 0.5, this.getInterpolated(this.pos.field_151328_c, this.oldPos.field_151328_c, partialTicks) + 0.5, 0.0f, partialTicks * 4.0f);
            GL11.glDisable((int)2896);
        }
    }

    private double getInterpolated(double newPos, double oldPos, float partialTicks) {
        double cosProgress = 0.5 - 0.5 * Math.cos(Math.min(Math.PI, (double)(this.progress + partialTicks * 0.1f)));
        return oldPos + (newPos - oldPos) * cosProgress;
    }

    public void addBlackListEntry(World world, int x, int y, int z) {
        this.blackListWireframes.add((Pair<RenderCoordWireframe, Integer>)new MutablePair((Object)new RenderCoordWireframe(world, x, y, z), (Object)60));
    }
}

