/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import pneumaticCraft.api.client.pneumaticHelmet.IOptionPage;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.client.gui.pneumaticHelmet.GuiCoordinateTrackerOptions;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.render.pneumaticArmor.RenderCoordWireframe;
import pneumaticCraft.client.render.pneumaticArmor.RenderNavigator;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.ai.EntityPathNavigateDrone;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketCoordTrackUpdate;

public class CoordTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private RenderCoordWireframe coordTracker;
    private RenderNavigator navigator;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    private int noPathCooldown;
    private int pathCalculateCooldown;
    public int pathUpdateSetting;
    public static final int SEARCH_RANGE = 150;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "coordinateTracker";
    }

    @Override
    public void initConfig(Configuration config) {
        this.pathEnabled = config.get("Helmet_Options.Coordinate_Tracker", "Path Enabled", true).getBoolean(true);
        this.wirePath = config.get("Helmet_Options.Coordinate_Tracker", "Wire Path", true).getBoolean(true);
        this.xRayEnabled = config.get("Helmet_Options.Coordinate_Tracker", "X-Ray", false).getBoolean(true);
        this.pathUpdateSetting = config.get("Helmet_Options.Coordinate_Tracker", "Path Update Rate", 1).getInt();
    }

    @Override
    public void saveToConfig() {
        Configuration config = Config.config;
        config.load();
        config.get("Helmet_Options.Coordinate_Tracker", "Path Enabled", true).set(this.pathEnabled);
        config.get("Helmet_Options.Coordinate_Tracker", "Wire Path", true).set(this.wirePath);
        config.get("Helmet_Options.Coordinate_Tracker", "X-Ray", true).set(this.xRayEnabled);
        config.get("Helmet_Options.Coordinate_Tracker", "Path Update Rate", true).set(this.pathUpdateSetting);
        config.save();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        if (this.coordTracker != null) {
            ++this.coordTracker.ticksExisted;
        } else {
            this.coordTracker = ItemPneumaticArmor.getCoordTrackLocation(player.func_82169_q(3));
            if (this.coordTracker != null) {
                this.navigator = new RenderNavigator(this.coordTracker.worldObj, this.coordTracker.x, this.coordTracker.y, this.coordTracker.z);
            }
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && this.pathEnabled && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = this.pathUpdateSetting == 2 ? 1 : (this.pathUpdateSetting == 1 ? 20 : 100);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        if (this.coordTracker != null) {
            if (FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w.field_76574_g != this.coordTracker.worldObj.field_73011_w.field_76574_g) {
                return;
            }
            this.coordTracker.render(partialTicks);
            if (this.pathEnabled && this.navigator != null) {
                this.navigator.render(this.wirePath, this.xRayEnabled, partialTicks);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public boolean isEnabled(ItemStack[] upgradeStacks) {
        for (ItemStack stack : upgradeStacks) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != 7) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.coordTracker = null;
        this.navigator = null;
    }

    @SubscribeEvent
    public boolean onPlayerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && this.isListeningToCoordTrackerSetting) {
            this.isListeningToCoordTrackerSetting = false;
            ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
            this.reset();
            ItemStack stack = event.entityPlayer.func_82169_q(3);
            if (stack != null) {
                NBTTagCompound tag = NBTUtil.getCompoundTag(stack, "CoordTracker");
                tag.func_74768_a("dimID", event.entity.field_70170_p.field_73011_w.field_76574_g);
                tag.func_74768_a("x", event.x + dir.offsetX);
                tag.func_74768_a("y", event.y + dir.offsetY);
                tag.func_74768_a("z", event.z + dir.offsetZ);
            }
            NetworkHandler.sendToServer(new PacketCoordTrackUpdate(event.entity.field_70170_p, event.x + dir.offsetX, event.y + dir.offsetY, event.z + dir.offsetZ));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumNavigationResult navigateToSurface(EntityPlayer player) {
        PathPoint pathPoint;
        int i;
        EnumNavigationResult result;
        World worldObj = player.field_70170_p;
        int y = worldObj.func_72976_f((int)player.field_70165_t, (int)player.field_70161_v);
        PathEntity path = worldObj.func_72844_a((Entity)player, (int)player.field_70165_t, y, (int)player.field_70161_v, 150.0f, true, true, false, true);
        EnumNavigationResult enumNavigationResult = result = path != null ? EnumNavigationResult.EASY_PATH : EnumNavigationResult.DRONE_PATH;
        if (path != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                if (!worldObj.func_72937_j(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c)) continue;
                this.coordTracker = new RenderCoordWireframe(worldObj, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                this.navigator = new RenderNavigator(worldObj, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackUpgradeHandler.getDronePath(player, (int)player.field_70165_t, y, (int)player.field_70161_v)) != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                if (!worldObj.func_72937_j(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c)) continue;
                this.coordTracker = new RenderCoordWireframe(worldObj, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                this.navigator = new RenderNavigator(worldObj, pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static PathEntity getDronePath(EntityPlayer player, int x, int y, int z) {
        World worldObj = player.field_70170_p;
        EntityDrone drone = new EntityDrone(worldObj);
        drone.func_70107_b(player.field_70165_t, player.field_70163_u - 2.0, player.field_70161_v);
        return new EntityPathNavigateDrone(drone, worldObj).getEntityPathToXYZ(drone, x, y, z, 150.0f, true, true, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiCoordinateTrackerOptions();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        return null;
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }
}

