/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.common.item.ItemProgrammingPuzzle;
import pneumaticCraft.common.progwidgets.IProgWidget;

@SideOnly(value=Side.CLIENT)
public class RenderItemProgrammingPuzzle
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        switch (type) {
            case ENTITY: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glDisable((int)2884);
                this.render(0.0f, 0.0f, 0.0f, 0.5f, item);
                GL11.glEnable((int)2884);
                break;
            }
            case EQUIPPED: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                this.render(-0.4f, -0.5f, -0.0f, 1.0f, item);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                this.render(-0.8f, -0.5f, 0.3f, 1.0f, item);
                break;
            }
            case INVENTORY: {
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                this.render(8.0f, 8.0f, 0.0f, 12.0f, item);
                GL11.glEnable((int)2929);
                break;
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void render(float x, float y, float z, float scale, ItemStack stack) {
        IProgWidget widget = ItemProgrammingPuzzle.getWidgetForPiece(stack);
        if (widget == null) {
            return;
        }
        int width = widget.getWidth() + (widget.getParameters() != null && widget.getParameters().length > 0 ? 10 : 0);
        int height = widget.getHeight() + (widget.hasStepOutput() ? 5 : 0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)(scale /= (float)Math.max(height, width)), (float)scale, (float)1.0f);
        GL11.glTranslatef((float)(-width / 2), (float)(-height / 2), (float)0.0f);
        widget.render();
        GL11.glPopMatrix();
    }
}

