/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.model;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.model.IBaseModel;

public class BaseModel
implements IBaseModel {
    protected final IModelCustom model;
    protected String[] staticParts;
    protected String[] dynamicParts;
    protected final ResourceLocation resLoc;
    public boolean rotatable;

    public BaseModel(String name) {
        this(name, (String[])null);
    }

    public BaseModel(String name, String textureName) {
        this(name, textureName, null, null);
    }

    public BaseModel(String name, String[] staticParts) {
        this(name, name.substring(0, name.lastIndexOf(46)) + ".png", staticParts, null);
    }

    public BaseModel(String name, String textureName, String[] staticParts, String[] dynamicParts) {
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("pneumaticcraft:models/" + name));
        this.resLoc = new ResourceLocation("pneumaticcraft:textures/model/" + textureName);
        this.staticParts = staticParts;
        this.dynamicParts = dynamicParts;
    }

    @Override
    public void renderStatic(float size, TileEntity te) {
        GL11.glPushMatrix();
        if (this.model instanceof WavefrontObject) {
            this.applyRenderPreps(te);
        }
        if (this.staticParts != null) {
            this.model.renderOnly(this.staticParts);
        } else {
            this.renderAll(te);
        }
        GL11.glPopMatrix();
    }

    protected void renderAll(TileEntity te) {
        this.model.renderAll();
    }

    protected void applyRenderPreps(TileEntity te) {
        if (te != null) {
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)-1.0, (double)0.0);
            GL11.glTranslated((double)-8.0, (double)0.0, (double)8.0);
        } else {
            GL11.glRotated((double)180.0, (double)-1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)-8.0, (double)0.0, (double)8.0);
        }
    }

    @Override
    public void renderDynamic(float size, TileEntity te, float partialTicks) {
        if (this.dynamicParts != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)size, (double)size, (double)size);
            this.model.renderOnly(this.dynamicParts);
            GL11.glPopMatrix();
        }
    }

    @Override
    public ResourceLocation getModelTexture(TileEntity tile) {
        return this.resLoc;
    }

    @Override
    public boolean rotateModelBasedOnBlockMeta() {
        return this.rotatable;
    }
}

