/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.widget;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.WidgetBase;
import pneumaticCraft.client.gui.widget.WidgetFluidStack;
import pneumaticCraft.common.recipes.AmadronOffer;
import pneumaticCraft.common.recipes.AmadronOfferCustom;
import pneumaticCraft.lib.Textures;

public class WidgetAmadronOffer
extends WidgetBase {
    private final AmadronOffer offer;
    private final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rectangle[] tooltipRectangles = new Rectangle[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int id, int x, int y, AmadronOffer offer) {
        super(id, x, y, 73, 35);
        this.offer = offer;
        if (offer.getInput() instanceof FluidStack) {
            this.widgets.add(new WidgetFluidStack(0, x + 6, y + 15, (FluidStack)offer.getInput()));
        }
        if (offer.getOutput() instanceof FluidStack) {
            this.widgets.add(new WidgetFluidStack(0, x + 51, y + 15, (FluidStack)offer.getOutput()));
        }
        this.tooltipRectangles[0] = new Rectangle(x + 6, y + 15, 16, 16);
        this.tooltipRectangles[1] = new Rectangle(x + 51, y + 15, 16, 16);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GL11.glDisable((int)2896);
        if (this.renderBackground) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_AMADRON_OFFER);
            GL11.glColor4d((double)1.0, (double)(this.canBuy ? 1.0 : 0.4), (double)(this.canBuy ? 1.0 : 0.4), (double)1.0);
            Gui.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.getBounds().width, (int)this.getBounds().height, (float)256.0f, (float)256.0f);
        }
        for (IGuiWidget widget : this.widgets) {
            widget.render(mouseX, mouseY, partialTick);
        }
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.offer.getVendor(), this.x + 2, this.y + 2, -16777216);
        boolean customOffer = this.offer instanceof AmadronOfferCustom;
        if (this.shoppingAmount > 0) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(this.shoppingAmount + "", this.x + 36 - Minecraft.func_71410_x().field_71466_p.func_78256_a("" + this.shoppingAmount) / 2, this.y + (customOffer ? 15 : 20), -16777216);
        }
        if (customOffer) {
            AmadronOfferCustom custom = (AmadronOfferCustom)this.offer;
            Minecraft.func_71410_x().field_71466_p.func_78276_b(EnumChatFormatting.DARK_BLUE.toString() + custom.getStock() + "", this.x + 36 - Minecraft.func_71410_x().field_71466_p.func_78256_a("" + custom.getStock()) / 2, this.y + 25, -16777216);
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public void setCanBuy(boolean canBuy) {
        this.canBuy = canBuy;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
        super.addTooltip(mouseX, mouseY, curTip, shiftPressed);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(mouseX, mouseY)) continue;
            widget.addTooltip(mouseX, mouseY, curTip, shiftPressed);
        }
        boolean isInBounds = false;
        for (Rectangle rect : this.tooltipRectangles) {
            if (!rect.contains(mouseX, mouseY)) continue;
            isInBounds = true;
        }
        if (!isInBounds) {
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.selling", (Object[])new Object[]{WidgetAmadronOffer.getStringForObject(this.offer.getOutput())}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.buying", (Object[])new Object[]{WidgetAmadronOffer.getStringForObject(this.offer.getInput())}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.vendor", (Object[])new Object[]{this.offer.getVendor()}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.inBasket", (Object[])new Object[]{this.shoppingAmount}));
            if (this.offer.getStock() >= 0) {
                curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.stock", (Object[])new Object[]{this.offer.getStock()}));
            }
            if (this.offer.getVendor().equals(PneumaticCraft.proxy.getPlayer().func_70005_c_())) {
                curTip.addAll(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.amadron.amadronWidget.sneakRightClickToRemove", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
            }
        }
    }

    public static String getStringForObject(Object o) {
        return WidgetAmadronOffer.getStringForObject(o, 1);
    }

    public static String getStringForObject(Object o, int times) {
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return times * stack.field_77994_a + "x " + stack.func_82833_r();
        }
        FluidStack stack = (FluidStack)o;
        return times * stack.amount + "mB " + stack.getLocalizedName();
    }

    public AmadronOffer getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }
}

