/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.GuiUtils;
import pneumaticCraft.common.inventory.ContainerChargingStationItemInventory;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketGuiButton;
import pneumaticCraft.common.tileentity.TileEntityChargingStation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiPneumaticInventoryItem
extends GuiPneumaticContainerBase<TileEntityChargingStation> {
    protected ItemStack itemStack;
    private GuiButton guiSelectButton;

    public GuiPneumaticInventoryItem(ContainerChargingStationItemInventory container, TileEntityChargingStation te) {
        super(container, te, "pneumaticcraft:textures/gui/GuiPneumaticArmor.png");
        this.itemStack = te.func_70301_a(0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.guiSelectButton = new GuiButton(2, xStart + 90, yStart + 15, 25, 20, "<--");
        this.field_146292_n.add(this.guiSelectButton);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        pressureStatText.add("\u00a77Current Pressure:");
        float curPressure = ((IPressurizable)this.itemStack.func_77973_b()).getPressure(((TileEntityChargingStation)this.te).func_70301_a(0));
        int volume = ItemPneumaticArmor.getUpgrades(0, ((TileEntityChargingStation)this.te).func_70301_a(0)) * 5000 + this.getDefaultVolume();
        pressureStatText.add("\u00a70" + (double)Math.round(curPressure * 10.0f) / 10.0 + " bar.");
        pressureStatText.add("\u00a77Current Air:");
        pressureStatText.add("\u00a70" + (double)Math.round(curPressure * (float)volume) + " mL.");
        pressureStatText.add("\u00a77Volume:");
        pressureStatText.add("\u00a70" + this.getDefaultVolume() + " mL.");
        if (volume > this.getDefaultVolume()) {
            pressureStatText.add("\u00a70" + (double)Math.round(volume - this.getDefaultVolume()) + " mL. (Volume Upgrades)");
            pressureStatText.add("\u00a70--------+");
            pressureStatText.add("\u00a70" + (double)Math.round(volume) + " mL.");
        }
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected abstract int getDefaultVolume();

    @Override
    protected void func_146284_a(GuiButton button) {
        NetworkHandler.sendToServer(new PacketGuiButton(button.field_146127_k));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String containerName = this.itemStack.func_82833_r();
        this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.tab.upgrades", (Object[])new Object[0]), 36, 14, 0x404040);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiUtils.drawPressureGauge(this.field_146289_q, 0.0f, 10.0f, 10.0f, 0.0f, ((IPressurizable)this.itemStack.func_77973_b()).getPressure(((TileEntityChargingStation)this.te).func_70301_a(0)), xStart + this.field_146999_f * 3 / 4 + 8, yStart + this.field_147000_g * 1 / 4 + 4, this.field_73735_i);
    }

    @Override
    protected Point getGaugeLocation() {
        return null;
    }
}

