/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.client.IGuiAnimatedStat;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.client.gui.GuiButtonSpecial;
import pneumaticCraft.client.gui.GuiUtils;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.client.gui.widget.IWidgetListener;
import pneumaticCraft.client.gui.widget.WidgetLabel;
import pneumaticCraft.client.gui.widget.WidgetTextField;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketGuiButton;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiPneumaticContainerBase<Tile extends TileEntityBase>
extends GuiContainer
implements INEIGuiHandler,
IWidgetListener {
    public final Tile te;
    private final ResourceLocation guiTexture;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private IGuiAnimatedStat lastLeftStat;
    private IGuiAnimatedStat lastRightStat;
    private GuiAnimatedStat pressureStat;
    protected GuiAnimatedStat problemTab;
    private GuiAnimatedStat redstoneTab;
    protected GuiButtonSpecial redstoneButton;

    public GuiPneumaticContainerBase(Container par1Container, Tile te, String guiTexture) {
        super(par1Container);
        this.te = te;
        this.guiTexture = guiTexture != null ? new ResourceLocation(guiTexture) : null;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ItemStack icon, int color, boolean leftSided) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiAnimatedStat stat = new GuiAnimatedStat((GuiScreen)this, title, icon, xStart + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, String icon, int color, boolean leftSided) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GuiAnimatedStat stat = new GuiAnimatedStat((GuiScreen)this, title, icon, xStart + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    protected void addWidgets(Iterable<IGuiWidget> widgets) {
        for (IGuiWidget widget : widgets) {
            this.addWidget(widget);
        }
    }

    protected void addLabel(String text, int x, int y) {
        this.addWidget(new WidgetLabel(x, y, text));
    }

    protected void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        if (this.shouldAddPressureTab() && this.te instanceof TileEntityPneumaticBase) {
            this.pressureStat = this.addAnimatedStat("gui.tab.pressure", new ItemStack(Blockss.pressureTube), -16733696, false);
        }
        if (this.shouldAddProblemTab()) {
            this.problemTab = this.addAnimatedStat("gui.tab.problems", "pneumaticcraft:textures/gui/GuiProblem.png", -65536, false);
        }
        if (this.shouldAddRedstoneTab() && this.te instanceof IRedstoneControl) {
            this.redstoneTab = this.addAnimatedStat("gui.tab.redstoneBehaviour", new ItemStack(Items.field_151137_ax), -3407872, true);
            ArrayList<String> curInfo = new ArrayList<String>();
            curInfo.add(I18n.func_135052_a((String)this.getRedstoneString(), (Object[])new Object[0]));
            for (int i = 0; i < 3; ++i) {
                curInfo.add("                                      ");
            }
            this.redstoneTab.setTextWithoutCuttingString(curInfo);
            Rectangle buttonRect = this.redstoneTab.getButtonScaledRectangle(-170, 24, 170, 20);
            this.redstoneButton = new GuiButtonSpecial(0, buttonRect.x, buttonRect.y, buttonRect.width, buttonRect.height, "-");
            this.redstoneTab.addWidget(this.redstoneButton);
        }
        if (this.te instanceof IInventory) {
            String info;
            String translatedInfo;
            if (this.shouldAddInfoTab() && !(translatedInfo = I18n.func_135052_a((String)(info = "gui.tab.info." + ((IInventory)this.te).func_145825_b()), (Object[])new Object[0])).equals(info)) {
                this.addInfoTab(translatedInfo);
            }
            if (this.te instanceof IHeatExchanger) {
                this.addAnimatedStat("gui.tab.info.heat.title", new ItemStack((Block)Blocks.field_150480_ab), -43776, false).setText("gui.tab.info.heat");
            }
            if (this.shouldAddUpgradeTab()) {
                String upgrades = "gui.tab.upgrades." + ((IInventory)this.te).func_145825_b();
                String translatedUpgrades = I18n.func_135052_a((String)upgrades, (Object[])new Object[0]);
                ArrayList<String> upgradeText = new ArrayList<String>();
                if (this.te instanceof TileEntityPneumaticBase) {
                    upgradeText.add("gui.tab.upgrades.volume");
                    upgradeText.add("gui.tab.upgrades.security");
                }
                if (this.te instanceof IHeatExchanger) {
                    upgradeText.add("gui.tab.upgrades.volumeCapacity");
                }
                if (!translatedUpgrades.equals(upgrades)) {
                    upgradeText.add(upgrades);
                }
                if (upgradeText.size() > 0) {
                    this.addAnimatedStat("gui.tab.upgrades", "pneumaticcraft:textures/gui/GuiUpgrade.png", -16776961, true).setText(upgradeText);
                }
            }
        }
    }

    protected void addInfoTab(String info) {
        if (!Loader.isModLoaded((String)"IGWMod")) {
            info = info + " \\n \\n" + I18n.func_135052_a((String)"gui.tab.info.assistIGW", (Object[])new Object[0]);
        }
        this.addAnimatedStat("gui.tab.info", "pneumaticcraft:textures/gui/GuiInfo.png", -7829249, true).setText(info);
    }

    protected boolean shouldAddRedstoneTab() {
        return true;
    }

    protected boolean shouldAddPressureTab() {
        return true;
    }

    protected boolean shouldAddUpgradeTab() {
        return true;
    }

    protected boolean shouldAddInfoTab() {
        return true;
    }

    protected boolean shouldAddProblemTab() {
        return true;
    }

    protected void func_146976_a(float partialTicks, int i, int j) {
        if (this.shouldDrawBackground()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)2896);
        for (IGuiWidget widget : this.widgets) {
            widget.render(i, j, partialTicks);
        }
        for (IGuiWidget widget : this.widgets) {
            widget.postRender(i, j, partialTicks);
        }
        if (this.pressureStat != null) {
            TileEntityPneumaticBase pneu = (TileEntityPneumaticBase)this.te;
            Point gaugeLocation = this.getGaugeLocation();
            if (gaugeLocation != null) {
                GuiUtils.drawPressureGauge(this.field_146289_q, -1.0f, pneu.CRITICAL_PRESSURE, pneu.DANGER_PRESSURE, this.te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)this.te).getMinWorkingPressure() : -1.0f, pneu.getPressure(ForgeDirection.UNKNOWN), gaugeLocation.x, gaugeLocation.y, this.field_73735_i);
            }
        }
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void bindGuiTexture() {
        if (this.guiTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiTexture);
            GL11.glEnable((int)3553);
        }
    }

    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + this.field_146999_f * 3 / 4, yStart + this.field_147000_g * 1 / 4 + 4);
    }

    protected void func_146979_b(int x, int y) {
        if (this.getInvNameOffset() != null && this.te instanceof IInventory) {
            IInventory inv = (IInventory)this.te;
            String containerName = inv.func_145818_k_() ? inv.func_145825_b() : StatCollector.func_74838_a((String)(inv.func_145825_b() + ".name"));
            this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2 + this.getInvNameOffset().x, 6 + this.getInvNameOffset().y, 0x404040);
        }
        if (this.getInvTextOffset() != null) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8 + this.getInvTextOffset().x, this.field_147000_g - 94 + this.getInvTextOffset().y, 0x404040);
        }
    }

    protected Point getInvNameOffset() {
        return new Point(0, 0);
    }

    protected Point getInvTextOffset() {
        return new Point(0, 0);
    }

    public void func_73863_a(int x, int y, float partialTick) {
        super.func_73863_a(x, y, partialTick);
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Object obj : this.field_146292_n) {
            if (!(obj instanceof GuiButtonSpecial)) continue;
            GuiButtonSpecial button = (GuiButtonSpecial)obj;
            if (button.field_146128_h >= x || button.field_146128_h + button.getWidth() <= x || button.field_146129_i >= y || button.field_146129_i + button.getHeight() <= y) continue;
            button.getTooltip(tooltip);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)2896);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, PneumaticCraft.proxy.isSneakingInGui());
        }
        if (tooltip.size() > 0) {
            this.drawHoveringString(tooltip, x, y, this.field_146289_q);
            tooltip.clear();
        }
    }

    public void func_73876_c() {
        ArrayList<String> curInfo;
        super.func_73876_c();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
        if (this.pressureStat != null) {
            curInfo = new ArrayList<String>();
            this.addPressureStatInfo(curInfo);
            this.pressureStat.setText(curInfo);
        }
        if (this.problemTab != null) {
            curInfo = new ArrayList();
            this.addProblems(curInfo);
            if (curInfo.size() == 0) {
                curInfo.add("gui.tab.problems.noProblems");
            }
            this.problemTab.setText(curInfo);
        }
        if (this.redstoneTab != null) {
            this.redstoneButton.field_146126_j = I18n.func_135052_a((String)this.getRedstoneButtonText(((IRedstoneControl)this.te).getRedstoneMode()), (Object[])new Object[0]);
        }
    }

    protected void func_146284_a(GuiButton button) {
        this.sendPacketToServer(button.field_146127_k);
    }

    public String getRedstoneButtonText(int mode) {
        switch (mode) {
            case 0: {
                return "gui.tab.redstoneBehaviour.button.anySignal";
            }
            case 1: {
                return "gui.tab.redstoneBehaviour.button.highSignal";
            }
            case 2: {
                return "gui.tab.redstoneBehaviour.button.lowSignal";
            }
        }
        return "<ERROR>";
    }

    public String getRedstoneString() {
        return this.te instanceof IRedstoneControlled ? "gui.tab.redstoneBehaviour.enableOn" : "gui.tab.redstoneBehaviour.emitRedstoneWhen";
    }

    protected void addPressureStatInfo(List<String> pressureStatText) {
        TileEntityPneumaticBase pneumaticTile = (TileEntityPneumaticBase)this.te;
        pressureStatText.add("\u00a77Current Pressure:");
        pressureStatText.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(pneumaticTile.getPressure(ForgeDirection.UNKNOWN), 1) + " bar.");
        pressureStatText.add("\u00a77Current Air:");
        pressureStatText.add("\u00a70" + (double)Math.round(pneumaticTile.currentAir + pneumaticTile.volume) + " mL.");
        pressureStatText.add("\u00a77Volume:");
        pressureStatText.add("\u00a70" + (double)Math.round(pneumaticTile.DEFAULT_VOLUME) + " mL.");
        float volumeLeft = pneumaticTile.volume - pneumaticTile.DEFAULT_VOLUME;
        if (volumeLeft > 0.0f) {
            pressureStatText.add("\u00a70" + (double)Math.round(volumeLeft) + " mL. (Volume Upgrades)");
            pressureStatText.add("\u00a70--------+");
            pressureStatText.add("\u00a70" + (double)Math.round(pneumaticTile.volume) + " mL.");
        }
    }

    protected void addProblems(List<String> curInfo) {
        if (this.te instanceof IRedstoneControlled && !((TileEntityBase)this.te).redstoneAllows()) {
            IRedstoneControlled redstoneControlled = (IRedstoneControlled)this.te;
            curInfo.add("gui.tab.problems.redstoneDisallows");
            if (redstoneControlled.getRedstoneMode() == 1) {
                curInfo.add("gui.tab.problems.provideRedstone");
            } else {
                curInfo.add("gui.tab.problems.removeRedstone");
            }
        }
        if (this.te instanceof IMinWorkingPressure) {
            IMinWorkingPressure minWork = (IMinWorkingPressure)this.te;
            if (((TileEntityPneumaticBase)this.te).getPressure(ForgeDirection.UNKNOWN) < minWork.getMinWorkingPressure()) {
                curInfo.add("gui.tab.problems.notEnoughPressure");
                curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.applyPressure", (Object[])new Object[]{Float.valueOf(minWork.getMinWorkingPressure())}));
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        for (IGuiWidget widget : this.widgets) {
            if (widget.getBounds().contains(par1, par2)) {
                widget.onMouseClicked(par1, par2, par3);
                continue;
            }
            widget.onMouseClickedOutsideBounds(par1, par2, par3);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof IGuiAnimatedStat) {
            boolean leftSided = ((IGuiAnimatedStat)((Object)widget)).isLeftSided();
            for (IGuiWidget w : this.widgets) {
                IGuiAnimatedStat stat;
                if (!(w instanceof IGuiAnimatedStat) || widget == (stat = (IGuiAnimatedStat)((Object)w)) || stat.isLeftSided() != leftSided) continue;
                stat.closeWindow();
            }
        }
        this.sendPacketToServer(widget.getID());
    }

    protected void sendPacketToServer(int id) {
        NetworkHandler.sendToServer(new PacketGuiButton(id));
    }

    public void func_146274_d() {
        super.func_146274_d();
        for (IGuiWidget widget : this.widgets) {
            widget.handleMouseInput();
        }
    }

    protected void func_73869_a(char key, int keyCode) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.onKey(key, keyCode)) continue;
            return;
        }
        super.func_73869_a(key, keyCode);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public void drawHoveringString(List<String> text, int x, int y, FontRenderer fontRenderer) {
        this.drawHoveringText(text, x, y, fontRenderer);
    }

    public static void drawTexture(String texture, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiUtils.getResourceLocation(texture));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + 16), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + 16), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public GuiButtonSpecial getButtonFromRectangle(int buttonID, Rectangle buttonSize, String buttonText) {
        return new GuiButtonSpecial(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, buttonText);
    }

    public GuiButtonSpecial getInvisibleButtonFromRectangle(int buttonID, Rectangle buttonSize) {
        return new GuiButtonSpecial(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, "");
    }

    public WidgetTextField getTextFieldFromRectangle(Rectangle textFieldSize) {
        return new WidgetTextField(this.field_146289_q, textFieldSize.x, textFieldSize.y, textFieldSize.width, textFieldSize.height);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        for (IGuiWidget w : this.widgets) {
            if (!(w instanceof IGuiAnimatedStat)) continue;
            IGuiAnimatedStat stat = (IGuiAnimatedStat)((Object)w);
            if (stat.isLeftSided()) {
                if (stat.getWidth() <= 20) continue;
                currentVisibility.showUtilityButtons = false;
                currentVisibility.showStateButtons = false;
                continue;
            }
            if (stat.getAffectedY() >= 10) continue;
            currentVisibility.showWidgets = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return new ArrayList<Integer>();
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        for (IGuiWidget widget : this.widgets) {
            IGuiAnimatedStat stat;
            if (!(widget instanceof IGuiAnimatedStat) || !(stat = (IGuiAnimatedStat)((Object)widget)).getBounds().intersects(new Rectangle(x, y, w, h))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
    }

    protected void refreshScreen() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        this.func_146280_a(Minecraft.func_71410_x(), i, j);
        for (IGuiWidget widget : this.widgets) {
            if (!(widget instanceof GuiAnimatedStat)) continue;
            widget.update();
        }
    }
}

