/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.widget.WidgetTank;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.inventory.ContainerLiquidCompressor;
import pneumaticCraft.common.tileentity.TileEntityLiquidCompressor;

public class GuiLiquidCompressor
extends GuiPneumaticContainerBase<TileEntityLiquidCompressor> {
    public GuiLiquidCompressor(InventoryPlayer player, TileEntityLiquidCompressor te) {
        super(new ContainerLiquidCompressor(player, te), te, "pneumaticcraft:textures/gui/GuiLiquidCompressor.png");
    }

    public GuiLiquidCompressor(Container container, TileEntityLiquidCompressor te, String texture) {
        super(container, te, texture);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addWidget(new WidgetTank(0, this.field_147003_i + this.getFluidOffset(), this.field_147009_r + 15, ((TileEntityLiquidCompressor)this.te).getFluidTank()));
        this.addAnimatedStat("gui.tab.liquidCompressor.fuel", new ItemStack(Items.field_151129_at), -39424, true).setTextWithoutCuttingString(this.getAllFuels());
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityLiquidCompressor)this.te).isProducing) {
            pressureStatText.add("\u00a77Currently producing:");
            pressureStatText.add("\u00a70" + (double)Math.round((float)(((TileEntityLiquidCompressor)this.te).getBaseProduction() * ((TileEntityLiquidCompressor)this.te).getEfficiency()) * ((TileEntityLiquidCompressor)this.te).getSpeedMultiplierFromUpgrades(((TileEntityLiquidCompressor)this.te).getUpgradeSlots()) / 100.0f) + " mL/tick.");
        }
    }

    protected int getFluidOffset() {
        return 86;
    }

    @Override
    protected Point getInvNameOffset() {
        return new Point(0, -2);
    }

    @Override
    protected Point getGaugeLocation() {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(xStart + this.field_146999_f * 3 / 4 + 5, yStart + this.field_147000_g * 1 / 4 + 4);
    }

    private List<String> getAllFuels() {
        ArrayList<String> fuels = new ArrayList<String>();
        fuels.add("L/Bucket | Fluid");
        for (Map.Entry<String, Integer> map : GuiLiquidCompressor.sortByValue(PneumaticCraftAPIHandler.getInstance().liquidFuels).entrySet()) {
            String value = map.getValue() / 1000 + "";
            while (this.field_146289_q.func_78256_a(value) < 25) {
                value = value + " ";
            }
            Fluid fluid = FluidRegistry.getFluid((String)map.getKey());
            fuels.add(value + "| " + fluid.getLocalizedName(new FluidStack(fluid, 1)));
        }
        return fuels;
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return -((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 15, 19, 0x404040);
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (!((TileEntityLiquidCompressor)this.te).isProducing && ((TileEntityLiquidCompressor)this.te).getTankInfo(null)[0].fluid == null) {
            curInfo.add("gui.tab.problems.liquidCompressor.noFuel");
        }
    }
}

