/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.api.tileentity;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pneumaticCraft.api.IHeatExchangerLogic;

public abstract class HeatBehaviour<Tile extends TileEntity> {
    private IHeatExchangerLogic connectedHeatLogic;
    private World world;
    private int x;
    private int y;
    private int z;
    private Tile cachedTE;
    private Block block;

    public void initialize(IHeatExchangerLogic connectedHeatLogic, World world, int x, int y, int z) {
        this.connectedHeatLogic = connectedHeatLogic;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.cachedTE = null;
        this.block = null;
    }

    public IHeatExchangerLogic getHeatExchanger() {
        return this.connectedHeatLogic;
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Tile getTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            this.cachedTE = this.world.func_147438_o(this.x, this.y, this.z);
        }
        return this.cachedTE;
    }

    public Block getBlock() {
        if (this.block == null) {
            this.block = this.world.func_147439_a(this.x, this.y, this.z);
        }
        return this.block;
    }

    public abstract String getId();

    public abstract boolean isApplicable();

    public abstract void update();

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
    }

    public boolean equals(Object o) {
        if (o instanceof HeatBehaviour) {
            HeatBehaviour behaviour = (HeatBehaviour)o;
            return behaviour.getId().equals(this.getId()) && behaviour.getX() == this.getX() && behaviour.getY() == this.getY() && behaviour.getZ() == this.getZ();
        }
        return false;
    }

    public int hashCode() {
        int i = this.getId().hashCode();
        i = i * 31 + this.getX();
        i = i * 31 + this.getY();
        i = i * 31 + this.getZ();
        return i;
    }
}

