/*
 * Decompiled with CFR 0.152.
 */
package reborncore.jtraits;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import reborncore.jtraits.Mixin;

public class ClassLoadingHelper {
    public static ClassLoadingHelper instance = new ClassLoadingHelper();
    private final Map<String, byte[]> bytecodes = new HashMap<String, byte[]>();
    private final Map<String, Mixin<?>> mixins = new HashMap();
    private final Method m_defineClass;

    private ClassLoadingHelper() {
        try {
            this.m_defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            this.m_defineClass.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Class<?> addMixin(String name, byte[] bytecode, Mixin<?> mixin) {
        this.bytecodes.put(name, bytecode);
        this.mixins.put(name, mixin);
        try {
            return (Class)this.m_defineClass.invoke((Object)this.getClass().getClassLoader(), name, bytecode, 0, bytecode.length);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Mixin<?> findMixin(String name) {
        if (this.mixins.containsKey(name)) {
            return this.mixins.get(name);
        }
        return null;
    }

    public Mixin<?> findMixin(Class<?> clazz, Class<?> trait) {
        return this.findMixin(Mixin.getName(clazz, trait).replace("/", "."));
    }

    public InputStream getResourceAsStream(String name) {
        for (String s : this.bytecodes.keySet()) {
            if (!(s.replace(".", "/") + ".class").equals(name)) continue;
            return new ByteArrayInputStream(this.bytecodes.get(s));
        }
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    public Map<String, Mixin<?>> getDefinedMixins() {
        return this.mixins;
    }
}

