/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchNBT && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (ItemUtils.isWildcard(a) || ItemUtils.isWildcard(b)) {
                return true;
            }
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT, boolean useOreDic) {
        if (ItemUtils.isItemEqual(a, b, matchDamage, matchNBT)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (useOreDic) {
            for (int inta : OreDictionary.getOreIDs((ItemStack)a)) {
                for (int intb : OreDictionary.getOreIDs((ItemStack)b)) {
                    if (inta != intb) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isWildcard(ItemStack stack) {
        return ItemUtils.isWildcard(stack.func_77960_j());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", slot);
            ItemUtils.writeItemToNBT(stack, itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_150295_c(tag, 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.func_150305_b(entry);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemUtils.readItemFromNBT(itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (stack.field_77994_a > 127) {
            stack.field_77994_a = 127;
        }
        stack.func_77955_b(data);
    }

    public static ItemStack readItemFromNBT(NBTTagCompound data) {
        return ItemStack.func_77949_a((NBTTagCompound)data);
    }

    public static List<ItemStack> getStackWithAllOre(ItemStack stack) {
        if (stack == null) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            for (ItemStack ore : OreDictionary.getOres((String)OreDictionary.getOreName((int)oreID))) {
                ItemStack newOre = ore.func_77946_l();
                newOre.field_77994_a = stack.field_77994_a;
                list.add(newOre);
            }
        }
        if (list.isEmpty()) {
            list.add(stack);
        }
        return list;
    }
}

