/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import reborncore.client.multiblock.IMultiblockRenderHook;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.client.multiblock.component.MultiblockComponent;
import reborncore.common.misc.Location;

public class MultiblockRenderEvent {
    private static RenderBlocks blockRender = RenderBlocks.getInstance();
    public MultiblockSet currentMultiblock;
    public static ChunkCoordinates anchor;
    public Location partent;
    public static int angle;

    public void setMultiblock(MultiblockSet set) {
        this.currentMultiblock = set;
        anchor = null;
        angle = 0;
        this.partent = null;
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71476_x != null && !mc.field_71439_g.func_70093_af()) {
            mc.field_71439_g.func_71045_bC();
            this.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.currentMultiblock != null && anchor == null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer == Minecraft.func_71410_x().field_71439_g) {
            anchor = new ChunkCoordinates(event.x, event.y, event.z);
            angle = MathHelper.func_76128_c((double)((double)event.entityPlayer.field_70177_z * 4.0 / 360.0 + 0.5)) & 3;
            event.setCanceled(true);
        }
    }

    private void renderPlayerLook(EntityPlayer player, MovingObjectPosition src) {
        if (this.currentMultiblock != null) {
            int anchorX = anchor != null ? MultiblockRenderEvent.anchor.field_71574_a : src.field_72311_b;
            int anchorY = anchor != null ? MultiblockRenderEvent.anchor.field_71572_b + 1 : src.field_72312_c + 1;
            int anchorZ = anchor != null ? MultiblockRenderEvent.anchor.field_71573_c : src.field_72309_d;
            Multiblock mb = this.currentMultiblock.getForEntity((Entity)player);
            for (MultiblockComponent comp : mb.getComponents()) {
                this.renderComponent(player.field_70170_p, mb, comp, anchorX, anchorY, anchorZ);
            }
        }
    }

    private boolean renderComponent(World world, Multiblock mb, MultiblockComponent comp, int anchorX, int anchorY, int anchorZ) {
        ChunkCoordinates pos = comp.getRelativePosition();
        int x = pos.field_71574_a + anchorX;
        int y = pos.field_71572_b + anchorY;
        int z = pos.field_71573_c + anchorZ;
        if (world.func_147439_a(x, y, z) == comp.getBlock() && world.func_72805_g(x, y, z) == comp.getMeta()) {
            return false;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glTranslated((double)((double)x + 0.5 - RenderManager.field_78725_b), (double)((double)y + 0.5 - RenderManager.field_78726_c), (double)((double)z + 0.5 - RenderManager.field_78723_d));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        MultiblockRenderEvent.blockRender.field_147844_c = false;
        Block block = comp.getBlock();
        if (IMultiblockRenderHook.renderHooks.containsKey(block)) {
            IMultiblockRenderHook.renderHooks.get(block).renderBlockForMultiblock((IBlockAccess)world, mb, block, comp.getMeta(), blockRender);
        } else {
            blockRender.func_147800_a(comp.getBlock(), comp.getMeta(), 1.0f);
        }
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        return true;
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.partent != null && event.x == this.partent.x && event.y == this.partent.y && event.z == this.partent.z && Minecraft.func_71410_x().field_71441_e == this.partent.world) {
            this.setMultiblock(null);
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.setMultiblock(null);
    }
}

