/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes.modules;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.aobd.items.AOBDItem;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.ConfigResearch;

public class Thaumcraft
extends RecipesModule {
    public Thaumcraft() {
        super(CompatType.THAUMCRAFT, "iron", "gold", "copper", "tin", "lead", "silver");
    }

    @Override
    public void initOre(Ore ore) {
        String name = ore.name();
        ItemStack cluster = Thaumcraft.getOreStack("cluster", ore);
        for (ItemStack block : OreDictionary.getOres((String)("ore" + name))) {
            String s1 = Item.func_150891_b((Item)block.func_77973_b()) + "," + block.func_77960_j();
            String s2 = Item.func_150891_b((Item)cluster.func_77973_b()) + "," + cluster.func_77960_j();
            FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"nativeCluster", (String)(s1 + "," + s2 + "," + 1));
        }
        GameRegistry.addSmelting((ItemStack)cluster, (ItemStack)Thaumcraft.getOreStack("ingot", ore, 2), (float)0.2f);
        ThaumcraftApi.addSmeltingBonus((ItemStack)cluster, (ItemStack)Thaumcraft.getOreStack("nugget", ore, 0));
        ItemStack nugget = Thaumcraft.getOreStack("nugget", ore, 9);
        if (nugget.func_77973_b() instanceof AOBDItem) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Thaumcraft.getOreStack("ingot", ore), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "nugget" + ore.name()}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(nugget, new Object[]{"ingot" + ore.name()}));
        }
    }

    @Override
    public void postInit() {
        boolean addedAtLeastOne = false;
        ArrayList<ResearchPage> pages = new ArrayList<ResearchPage>();
        pages.add(new ResearchPage("tc.research_page.PUREORE.1"));
        for (Ore ore : Ore.ores) {
            if (!this.isOreEnabled(ore)) continue;
            String name = ore.name();
            ItemStack cluster = Thaumcraft.getOreStack("cluster", ore);
            CrucibleRecipe recipe = ThaumcraftApi.addCrucibleRecipe((String)"PUREORE", (ItemStack)cluster, (Object)("ore" + name), (AspectList)new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1));
            ConfigResearch.recipes.put("Pure" + name, recipe);
            pages.add(new ResearchPage(recipe));
            addedAtLeastOne = true;
        }
        if (addedAtLeastOne) {
            ResourceLocation texture = new ResourceLocation("aobd", "textures/items/research_cluster.png");
            ResearchCategories.registerCategory((String)"AOBD", (ResourceLocation)texture, (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png"));
            new ResearchItem("PUREORE", "AOBD", new AspectList().add(Aspect.METAL, 5).add(Aspect.ORDER, 2), 0, 0, 1, texture).setPages(pages.toArray(new ResearchPage[pages.size()])).setSecondary().setParents(new String[]{"PUREIRON"}).registerResearchItem();
        }
    }
}

