/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.blocks;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.aobd.AOBD;
import ganymedes01.aobd.ore.Ore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;

public class AOBDBlock
extends Block {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static final List<AOBDBlock> ALL_BLOCKS = new ArrayList<AOBDBlock>();
    public static final Map<String, Float> BLOCKS_PREFIXES = new HashMap<String, Float>();
    public static final Map<String, Material> BLOCKS_MATERIALS = new HashMap<String, Material>();
    public static final Map<String, Block.SoundType> BLOCKS_SOUNDS = new HashMap<String, Block.SoundType>();
    public static final List<String> BLOCKS_WITH_OVERLAYS = new ArrayList<String>();
    public boolean isRenderingOverlay = false;
    protected final Ore ore;
    protected final String base;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlay;

    public AOBDBlock(String base, Ore ore) {
        this(BLOCKS_MATERIALS.get(base), base, ore);
    }

    public AOBDBlock(Material material, String base, Ore ore) {
        super(material);
        this.ore = ore;
        this.base = base;
        Float hardness = BLOCKS_PREFIXES.get(base);
        this.func_149711_c(hardness == null ? 1.0f : hardness.floatValue());
        this.func_149672_a(BLOCKS_SOUNDS.get(base));
        this.func_149647_a(AOBD.tab);
        this.func_149663_c("aobd." + base + ore);
        this.func_149658_d("aobd:" + base);
        ALL_BLOCKS.add(this);
    }

    protected String getFullName() {
        return "tile.aobd." + this.base + this.ore.name() + ".name";
    }

    protected String getShortName() {
        return "tile.aobd." + this.base + ".name";
    }

    public String getBaseName() {
        return this.base;
    }

    public Ore getOre() {
        return this.ore;
    }

    public int func_149645_b() {
        return RENDER_ID;
    }

    public String func_149732_F() {
        String fullName = this.getFullName();
        String shortName = this.getShortName();
        return StatCollector.func_94522_b((String)fullName) ? StatCollector.func_74838_a((String)fullName) : String.format(StatCollector.func_74838_a((String)shortName), this.ore.translatedName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.isRenderingOverlay ? this.overlay : super.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        if (BLOCKS_WITH_OVERLAYS.contains(this.base)) {
            this.overlay = reg.func_94245_a(this.func_149641_N() + "_overlay");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.isRenderingOverlay ? super.func_149720_d(world, x, y, z) : this.ore.colour();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.isRenderingOverlay ? super.func_149741_i(meta) : this.ore.colour();
    }

    static {
        BLOCKS_PREFIXES.put("block", Float.valueOf(4.0f));
        BLOCKS_PREFIXES.put("oreSand", Float.valueOf(0.4f));
        BLOCKS_PREFIXES.put("oreDust", Float.valueOf(0.6f));
        BLOCKS_PREFIXES.put("oreGravel", Float.valueOf(0.8f));
        BLOCKS_PREFIXES.put("oreNetherGravel", Float.valueOf(0.8f));
        BLOCKS_MATERIALS.put("block", Material.field_151573_f);
        BLOCKS_MATERIALS.put("oreSand", Material.field_151595_p);
        BLOCKS_MATERIALS.put("oreDust", Material.field_151595_p);
        BLOCKS_MATERIALS.put("oreGravel", Material.field_151595_p);
        BLOCKS_MATERIALS.put("oreNetherGravel", Material.field_151595_p);
        BLOCKS_SOUNDS.put("block", Block.field_149777_j);
        BLOCKS_SOUNDS.put("oreSand", Block.field_149776_m);
        BLOCKS_SOUNDS.put("oreDust", Block.field_149776_m);
        BLOCKS_SOUNDS.put("oreGravel", Block.field_149767_g);
        BLOCKS_SOUNDS.put("oreNetherGravel", Block.field_149767_g);
        BLOCKS_WITH_OVERLAYS.add("oreGravel");
        BLOCKS_WITH_OVERLAYS.add("oreNetherGravel");
    }
}

