/*
 * Decompiled with CFR 0.152.
 */
package com.sci.torcherino.update;

import com.sci.torcherino.update.IUpdatableMod;
import com.sci.torcherino.update.ModVersion;
import com.sci.torcherino.update.UpdateData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

class UpdateCheckThread
extends Thread {
    private IUpdatableMod mod;
    private boolean checkComplete = false;
    private boolean newVer = false;
    private ModVersion latest;
    private String description;

    public UpdateCheckThread(IUpdatableMod mod) {
        super("TorcherinoUpdater: " + mod.name());
        this.mod = mod;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        int attempt = 0;
        while (attempt < 5) {
            ++attempt;
            try {
                URL versionUrl = new URL(this.mod.updateURL());
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(versionUrl.openStream()));
                String line = reader.readLine();
                while (true) {
                    sb.append(line);
                    line = reader.readLine();
                    if (line == null) break;
                    sb.append('\n');
                }
                reader.close();
                UpdateData data = UpdateData.parse(sb.toString());
                if (data.latest == null) continue;
                this.latest = data.latest;
                this.description = data.description;
                this.newVer = this.mod.version().isNewer(data.latest);
                this.checkComplete = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        this.checkComplete = true;
    }

    public boolean checkComplete() {
        return this.checkComplete;
    }

    public boolean newVersionAvailable() {
        return this.newVer;
    }

    public ModVersion latest() {
        return this.latest;
    }

    public String description() {
        return this.description;
    }
}

