/*
 * Decompiled with CFR 0.152.
 */
package com.sci.torcherino.update;

public final class ModVersion {
    private static final ModVersion NULL_VERSION = new ModVersion(0, 0);
    private int major;
    private int minor;

    public ModVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static ModVersion parse(String version) {
        try {
            String[] parts = version.split("\\.");
            return new ModVersion(Integer.valueOf(parts[0]), Integer.valueOf(parts[1].substring(0, parts[1].length() - 1)));
        }
        catch (Throwable t) {
            return NULL_VERSION;
        }
    }

    public String toString() {
        return this.major + "." + this.minor + "s";
    }

    public boolean isNewer(ModVersion newer) {
        if (newer.major > this.major) {
            return true;
        }
        return newer.minor > this.minor;
    }
}

