/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty.opencomputers;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.thirdparty.CommonAPI;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.math.Vec3i;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.driver.SidedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AugmentDriver
implements SidedBlock {
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection facing) {
        Vec3i pos = new Vec3i(x, y, z);
        TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(pos, TileRailBase.class);
        if (te == null) {
            return null;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return null;
        }
        switch (augment) {
            case DETECTOR: {
                return new DetectorAugment(world, pos);
            }
            case LOCO_CONTROL: {
                return new LocoControlAugment(world, pos);
            }
        }
        return null;
    }

    public boolean worksWith(World world, int x, int y, int z, ForgeDirection facing) {
        Vec3i pos = new Vec3i(x, y, z);
        TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(pos, TileRailBase.class);
        if (te == null) {
            return false;
        }
        Augment augment = te.getAugment();
        if (augment == null) {
            return false;
        }
        switch (augment) {
            case DETECTOR: 
            case LOCO_CONTROL: {
                return true;
            }
        }
        return false;
    }

    public class LocoControlAugment
    extends DetectorAugment {
        public LocoControlAugment(World world, Vec3i pos) {
            super(world, pos);
            this.typeFilter = Locomotive.class;
        }

        @Override
        public String preferredName() {
            return "ir_augment_control";
        }

        @Callback(doc="function(double) -- sets the locomotive throttle")
        public Object[] setThrottle(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setThrottle(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function(double) -- sets the locomotive reverser")
        public Object[] setReverser(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setReverser(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function(double) -- sets the train brake")
        public Object[] setBrake(Context context, Arguments arguments) throws Exception {
            return this.setTrainBrake(context, arguments);
        }

        @Callback(doc="function(double) -- sets the train brake")
        public Object[] setTrainBrake(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setTrainBrake(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function(double) -- sets the independent brake")
        public Object[] setIndependentBrake(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setIndependentBrake(arguments.checkDouble(0));
            }
            return null;
        }

        @Callback(doc="function() -- fires the locomotive horn")
        public Object[] horn(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setHorn(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function() -- sets the locomotive bell")
        public Object[] bell(Context context, Arguments arguments) throws Exception {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            if (api != null) {
                api.setBell(arguments.optInteger(0, 40));
            }
            return null;
        }

        @Callback(doc="function():boolean or nil -- gets the ignition state of bound diesel locomotive")
        public Object[] getIgnition(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            return new Object[]{api.getIgnition()};
        }

        @Callback(doc="function(boolean: on) -- sets the ignition of the bound diesel locomotive")
        public Object[] setIgnition(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos, Locomotive.class);
            api.setIgnition(arguments.checkBoolean(0));
            return null;
        }
    }

    public class DetectorAugment
    extends AugmentManagerBase {
        public DetectorAugment(World world, Vec3i pos) {
            super(world, pos);
        }

        public String preferredName() {
            return "ir_augment_detector";
        }

        @Callback(doc="function():table -- returns an info dump about the current car")
        public Object[] info(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.info()};
            }
            return null;
        }

        @Callback(doc="function():table -- returns an info dump about the current consist")
        public Object[] consist(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.consist(true)};
            }
            return null;
        }

        @Callback(doc="function():table -- gets the stock's tag")
        public Object[] getTag(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                return new Object[]{api.getTag()};
            }
            return null;
        }

        @Callback(doc="function():table -- sets the stock's tag")
        public Object[] setTag(Context context, Arguments arguments) {
            CommonAPI api = CommonAPI.create(this.world, this.pos);
            if (api != null) {
                api.setTag(arguments.checkString(0));
            }
            return null;
        }

        @Callback(doc="function():string -- returns the current augment type")
        public Object[] getAugmentType(Context context, Arguments args) {
            TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)this.world).getBlockEntity(this.pos, TileRailBase.class);
            Augment augment = te.getAugment();
            if (augment != null) {
                return new Object[]{augment.toString()};
            }
            return null;
        }

        @Callback(doc="function():array -- returns the position of the augment")
        public Object[] getPos(Context context, Arguments args) {
            return new Object[]{this.pos.x, this.pos.y, this.pos.z};
        }
    }

    public abstract class AugmentManagerBase
    extends li.cil.oc.api.prefab.ManagedEnvironment
    implements NamedBlock {
        protected final World world;
        protected final Vec3i pos;
        private int ticksAlive;
        private UUID wasOverhead;
        protected Class<? extends EntityRollingStock> typeFilter = EntityRollingStock.class;

        public AugmentManagerBase(World world, Vec3i pos) {
            this.world = world;
            this.pos = pos;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.preferredName(), Visibility.Network).create());
        }

        public boolean canUpdate() {
            return true;
        }

        public void update() {
            EntityRollingStock nearby;
            TileRailBase te;
            Node node = this.node();
            if (this.ticksAlive == 0) {
                te = (TileRailBase)cam72cam.mod.world.World.get((World)this.world).getBlockEntity(this.pos, TileRailBase.class);
                nearby = te.getStockNearBy(this.typeFilter);
                UUID uUID = this.wasOverhead = nearby != null ? nearby.getUUID() : null;
            }
            if (node != null && this.ticksAlive % Math.max(Config.ConfigDebug.ocPollDelayTicks, 1) == 0) {
                UUID isOverhead;
                te = (TileRailBase)cam72cam.mod.world.World.get((World)this.world).getBlockEntity(this.pos, TileRailBase.class);
                nearby = te.getStockNearBy(this.typeFilter);
                UUID uUID = isOverhead = nearby != null ? nearby.getUUID() : null;
                if (isOverhead != this.wasOverhead) {
                    Node neighbor = (Node)node.neighbors().iterator().next();
                    neighbor.sendToReachable("computer.signal", new Object[]{"ir_train_overhead", te.getAugment().toString(), isOverhead == null ? null : isOverhead.toString()});
                }
                this.wasOverhead = isOverhead;
            }
            ++this.ticksAlive;
        }

        public int priority() {
            return 3;
        }
    }
}

