/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.thirdparty.event.TagEvent;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;

public class CommonAPI {
    private final EntityRollingStock stock;

    public static CommonAPI create(World world, Vec3i pos) {
        return CommonAPI.create(world, pos, EntityRollingStock.class);
    }

    public static CommonAPI create(World world, Vec3i pos, Class<? extends EntityRollingStock> stockClass) {
        EntityRollingStock stock;
        TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(pos, TileRailBase.class);
        if (te != null && (stock = te.getStockNearBy(stockClass)) != null) {
            return new CommonAPI(stock);
        }
        return null;
    }

    public CommonAPI(EntityRollingStock stock) {
        this.stock = stock;
    }

    public FluidStack getFluid() {
        if (this.stock instanceof FreightTank) {
            FreightTank tank = (FreightTank)this.stock;
            return tank.getLiquid() != null ? new FluidStack(tank.getLiquid().internal, tank.getLiquidAmount()) : null;
        }
        return null;
    }

    public Map<String, Object> info() {
        if (this.stock != null) {
            FluidStack fluid;
            HashMap<String, Object> info = new HashMap<String, Object>();
            EntityRollingStockDefinition def = this.stock.getDefinition();
            info.put("id", def.defID);
            info.put("name", def.name());
            info.put("tag", this.stock.tag);
            info.put("weight", this.stock.getWeight());
            Facing dir = Facing.fromAngle((float)this.stock.getRotationYaw());
            if (this.stock instanceof EntityMoveableRollingStock) {
                EntityMoveableRollingStock movable = (EntityMoveableRollingStock)this.stock;
                info.put("speed", movable.getCurrentSpeed().metric());
                if (movable.getCurrentSpeed().metric() < 0.0) {
                    dir = dir.getOpposite();
                }
            }
            info.put("direction", dir.toString());
            if (this.stock instanceof EntityRidableRollingStock) {
                info.put("passengers", this.stock.getPassengerCount());
            }
            if (this.stock instanceof EntityMoveableRollingStock) {
                info.put("independent_brake", Float.valueOf(((EntityMoveableRollingStock)this.stock).getIndependentBrake()));
            }
            if (this.stock instanceof Locomotive) {
                Locomotive loco = (Locomotive)this.stock;
                LocomotiveDefinition locoDef = loco.getDefinition();
                info.put("horsepower", locoDef.getHorsePower(loco.gauge));
                info.put("traction", locoDef.getStartingTractionNewtons(loco.gauge));
                info.put("max_speed", locoDef.getMaxSpeed(loco.gauge).metric());
                info.put("brake", Float.valueOf(loco.getTrainBrake()));
                info.put("train_brake", Float.valueOf(loco.getTrainBrake()));
                info.put("throttle", Float.valueOf(loco.getThrottle()));
                info.put("reverser", Float.valueOf(loco.getReverser()));
                if (loco instanceof LocomotiveSteam) {
                    LocomotiveSteam steam = (LocomotiveSteam)loco;
                    info.put("pressure", Float.valueOf(steam.getBoilerPressure()));
                    info.put("temperature", Float.valueOf(steam.getBoilerTemperature()));
                }
                if (loco instanceof LocomotiveDiesel) {
                    info.put("ignition", ((LocomotiveDiesel)loco).isTurnedOn());
                    info.put("temperature", Float.valueOf(((LocomotiveDiesel)loco).getEngineTemperature()));
                }
            }
            if ((fluid = this.getFluid()) != null) {
                info.put("fluid_type", fluid.getFluid().getName());
                info.put("fluid_amount", fluid.amount);
            } else {
                info.put("fluid_type", null);
                info.put("fluid_amount", 0);
            }
            if (this.stock instanceof FreightTank) {
                info.put("fluid_max", ((FreightTank)this.stock).getTankCapacity().MilliBuckets());
            }
            if (this.stock instanceof Freight) {
                Freight freight = (Freight)this.stock;
                info.put("cargo_percent", freight.getPercentCargoFull());
                info.put("cargo_size", freight.getInventorySize());
            }
            return info;
        }
        return null;
    }

    public Map<String, Object> consist(boolean supportsList) {
        if (!(this.stock instanceof EntityCoupleableRollingStock)) {
            return null;
        }
        EntityCoupleableRollingStock stock = (EntityCoupleableRollingStock)this.stock;
        int traction = 0;
        TrainIterator acc = new TrainIterator();
        stock.mapTrain(stock, true, true, acc::accept);
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> locos = new ArrayList<Map<String, Object>>();
        info.put("cars", acc.count);
        info.put("tractive_effort_N", acc.tractiveEffortNewtons);
        info.put("weight_kg", acc.massToMoveKg);
        info.put("speed_km", stock.getCurrentSpeed().metric());
        Facing dir = Facing.fromAngle((float)stock.getRotationYaw());
        if (stock.getCurrentSpeed().metric() < 0.0) {
            dir = dir.getOpposite();
        }
        info.put("direction", dir.toString());
        for (EntityCoupleableRollingStock car : stock.getTrain()) {
            if (!(car instanceof Locomotive)) continue;
            LocomotiveDefinition locoDef = ((Locomotive)car).getDefinition();
            traction += locoDef.getStartingTractionNewtons(car.gauge);
            locos.add(new CommonAPI(car).info());
        }
        if (supportsList) {
            info.put("locomotives", locos);
        } else {
            HashMap locomotives = new HashMap();
            for (int i = 0; i < locos.size(); ++i) {
                locomotives.put("" + i, locos.get(i));
            }
            info.put("locomotives", locomotives);
        }
        info.put("total_traction_N", traction);
        return info;
    }

    public String getTag() {
        TagEvent.GetTagEvent tagEvent = new TagEvent.GetTagEvent(this.stock.getUUID());
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        if (tagEvent.tag != null) {
            return tagEvent.tag;
        }
        return this.stock.tag;
    }

    public void setTag(String tag) {
        TagEvent.SetTagEvent tagEvent = new TagEvent.SetTagEvent(this.stock.getUUID(), tag);
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        this.stock.tag = tag;
    }

    private float normalize(double val) {
        if (Double.isNaN(val)) {
            return 0.0f;
        }
        if (val > 1.0) {
            return 1.0f;
        }
        if (val < -1.0) {
            return -1.0f;
        }
        return (float)val;
    }

    public void setThrottle(double throttle) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setThrottle(this.normalize(throttle));
        }
    }

    public void setReverser(double reverser) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setReverser(this.normalize(reverser));
        }
    }

    public void setTrainBrake(double brake) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setTrainBrake(this.normalize(brake));
        }
    }

    public void setIndependentBrake(double brake) {
        if (this.stock instanceof EntityMoveableRollingStock) {
            ((Locomotive)this.stock).setIndependentBrake(this.normalize(brake));
        }
    }

    public void setHorn(int horn) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setHorn(horn, null);
        }
    }

    public void setBell(int bell) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setBell(bell);
        }
    }

    public Vec3d getPosition() {
        return this.stock.getPosition();
    }

    public UUID getUniqueID() {
        return this.stock.getUUID();
    }

    public Boolean getIgnition() {
        if (this.stock instanceof LocomotiveDiesel) {
            return ((LocomotiveDiesel)this.stock).isTurnedOn();
        }
        return null;
    }

    public void setIgnition(boolean on) {
        if (this.stock instanceof LocomotiveDiesel) {
            ((LocomotiveDiesel)this.stock).setTurnedOn(on);
        }
    }

    private static class TrainIterator {
        private int count;
        private double tractiveEffortNewtons;
        private double massToMoveKg;

        private TrainIterator() {
        }

        public void accept(EntityCoupleableRollingStock stock, boolean direction) {
            ++this.count;
            this.tractiveEffortNewtons += stock instanceof Locomotive ? ((Locomotive)stock).getTractiveEffortNewtons(stock.getCurrentSpeed()) * (double)(direction ? 1 : -1) : 0.0;
            this.massToMoveKg += stock.getWeight();
        }
    }
}

