/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.ItemPlate;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.energy.IEnergy;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.world.World;

public class BoilerRollerMultiblock
extends Multiblock {
    private static Multiblock.FuzzyProvider slab = () -> Fuzzy.STONE_SLAB;
    public static final String NAME = "BOILER_MACHINE";
    private static final Vec3i render = new Vec3i(2, 0, 0);
    private static final Vec3i power = new Vec3i(5, 0, 3);
    private static final Vec3i crafting = new Vec3i(2, 0, 4);

    private static Multiblock.FuzzyProvider[][][] componentGenerator() {
        Multiblock.FuzzyProvider[] bed = new Multiblock.FuzzyProvider[]{BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.H_ENG(), BoilerRollerMultiblock.H_ENG()};
        Multiblock.FuzzyProvider[] table = new Multiblock.FuzzyProvider[]{slab, slab, slab, slab, AIR, AIR};
        Multiblock.FuzzyProvider[][][] result = new Multiblock.FuzzyProvider[][][]{{table}, {table}, {table}, {bed}, {bed}, {table}, {table}, {table}};
        return result;
    }

    public BoilerRollerMultiblock() {
        super(NAME, BoilerRollerMultiblock.componentGenerator());
    }

    @Override
    public Vec3i placementPos() {
        return new Vec3i(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, Vec3i origin, Rotation rot) {
        return new BoilerRollerInstance(world, origin, rot);
    }

    public class BoilerRollerInstance
    extends Multiblock.MultiblockInstance {
        public BoilerRollerInstance(World world, Vec3i origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(Player player, Player.Hand hand, Vec3i offset) {
            if (this.world.isClient) {
                return false;
            }
            if (!player.isCrouching()) {
                ItemStack held = player.getHeldItem(hand);
                if (held.isEmpty()) {
                    TileMultiblock craftTe = this.getTile(crafting);
                    if (craftTe == null) {
                        return false;
                    }
                    ItemStack outstack = craftTe.getContainer().get(1);
                    if (!outstack.isEmpty()) {
                        this.world.dropItem(outstack, player.getPosition());
                        craftTe.getContainer().set(1, ItemStack.EMPTY);
                    }
                } else if (held.is((CustomItem)IRItems.ITEM_PLATE) && new ItemPlate.Data((ItemStack)held).type == PlateType.BOILER) {
                    TileMultiblock craftTe = this.getTile(crafting);
                    if (craftTe == null) {
                        return false;
                    }
                    if (craftTe.getContainer().get(0).isEmpty()) {
                        ItemStack inputStack = held.copy();
                        inputStack.setCount(1);
                        craftTe.getContainer().set(0, inputStack);
                        held.shrink(1);
                        player.setHeldItem(hand, held);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isRender(Vec3i offset) {
            return offset.equals((Object)render);
        }

        @Override
        public int getInvSize(Vec3i offset) {
            return offset.equals((Object)crafting) ? 2 : 0;
        }

        @Override
        public void tick(Vec3i offset) {
            if (!offset.equals((Object)crafting)) {
                return;
            }
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.isClient) {
                if (craftTe.getRenderTicks() % 10L == 0L && craftTe.getCraftProgress() != 0) {
                    Audio.playSound((World)this.world, (Vec3i)craftTe.getPos(), (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.MASTER, (float)(1.0f * ConfigSound.SoundCategories.Machines.category()), (float)0.2f);
                }
                return;
            }
            if (craftTe.getCraftProgress() != 0) {
                IEnergy energy = powerTe.getEnergy(null);
                energy.extract(this.powerRequired(), false);
                craftTe.setCraftProgress(Math.max(0, craftTe.getCraftProgress() - 1));
            }
            float progress = craftTe.getCraftProgress();
            ItemStack input = craftTe.getContainer().get(0);
            ItemStack output = craftTe.getContainer().get(1);
            if (progress == 0.0f && input.is((CustomItem)IRItems.ITEM_PLATE) && new ItemPlate.Data((ItemStack)input).type == PlateType.BOILER && output.isEmpty()) {
                progress = 100.0f;
                craftTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = new ItemStack((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT, 1);
                ItemPlate.Data source = new ItemPlate.Data(input);
                ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(out);
                data.def = source.def;
                data.gauge = source.gauge;
                data.componentType = ItemComponentType.BOILER_SEGMENT;
                data.write();
                craftTe.getContainer().set(1, out);
                input.shrink(1);
                craftTe.getContainer().set(0, input);
            }
        }

        @Override
        public boolean canInsertItem(Vec3i pos, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public boolean isOutputSlot(Vec3i pos, int slot) {
            return false;
        }

        @Override
        public int getSlotLimit(Vec3i offset, int slot) {
            return offset.equals((Object)crafting) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(Vec3i offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            return powerTe.getEnergy(null).getCurrent() >= this.powerRequired();
        }

        public boolean hasInput() {
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return false;
            }
            return !craftTe.getContainer().get(0).isEmpty();
        }

        public boolean hasOutput() {
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return false;
            }
            return !craftTe.getContainer().get(1).isEmpty();
        }

        private int powerRequired() {
            return (int)Math.ceil(32.0f * Config.ConfigBalance.machinePowerFactor);
        }
    }
}

