/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Particles;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.render.ExpireableMap;
import cam72cam.immersiverailroading.render.SmokeParticle;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.sound.ISound;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Whistle {
    private final ModelComponent component;
    private final Quilling quilling;
    private final PartSound whistle;
    private final ExpireableMap<UUID, SoundEffects> sounds = new ExpireableMap<UUID, SoundEffects>(){

        @Override
        public void onRemove(UUID key, SoundEffects value) {
            value.terminate();
        }
    };

    public static Whistle get(ComponentProvider provider, ModelState state, Quilling quilling, EntityRollingStockDefinition.SoundDefinition fallback) {
        return new Whistle(provider.parse(ModelComponentType.WHISTLE), state, quilling, fallback);
    }

    public Whistle(ModelComponent whistle, ModelState state, Quilling quilling, EntityRollingStockDefinition.SoundDefinition fallback) {
        this.component = whistle;
        this.quilling = quilling;
        this.whistle = new PartSound(fallback, true, 150.0f, ConfigSound.SoundCategories.Locomotive.Steam::whistle);
        state.include(whistle);
    }

    public void effects(EntityMoveableRollingStock stock, int hornTime, float hornPull) {
        if (this.quilling != null) {
            SoundEffects sound = this.sounds.get(stock.getUUID());
            if (sound == null) {
                sound = new SoundEffects(stock);
                this.sounds.put(stock.getUUID(), sound);
            }
            sound.update(stock, hornTime, hornPull);
        } else {
            this.whistle.effects(stock, hornTime > 0);
        }
        Vec3d fakeMotion = stock.getVelocity();
        if (this.component != null && hornTime > 0) {
            Vec3d particlePos = stock.getPosition().add(VecUtil.rotateWrongYaw(this.component.center.scale(stock.gauge.scale()), stock.getRotationYaw() + 180.0f));
            particlePos = particlePos.subtract(fakeMotion);
            float darken = 0.0f;
            float thickness = 1.0f;
            double smokeMod = Math.min(1.0, Math.max(0.2, Math.abs(stock.getCurrentSpeed().minecraft()) * 2.0));
            int lifespan = (int)(40.0 * (1.0 + smokeMod * stock.gauge.scale()));
            double verticalSpeed = (double)0.8f * stock.gauge.scale();
            double size = 0.3 * (0.8 + smokeMod) * stock.gauge.scale();
            Particles.SMOKE.accept(new SmokeParticle.SmokeParticleData(stock.getWorld(), particlePos, new Vec3d(fakeMotion.x, fakeMotion.y + verticalSpeed, fakeMotion.z), lifespan, darken, thickness, size, stock.getDefinition().steamParticleTexture));
        }
    }

    public void removed(EntityMoveableRollingStock stock) {
        SoundEffects sound = this.sounds.get(stock.getUUID());
        if (sound != null) {
            sound.terminate();
        }
        this.whistle.removed(stock);
    }

    private class SoundEffects {
        private final List<ISound> chimes = new ArrayList<ISound>();
        private float pullString = 0.0f;
        private float soundDampener = 0.0f;

        private SoundEffects(EntityMoveableRollingStock stock) {
            for (Quilling.Chime chime : ((Whistle)Whistle.this).quilling.chimes) {
                this.chimes.add(stock.createSound(chime.sample, true, 150.0, ConfigSound.SoundCategories.Locomotive.Steam::whistle));
            }
        }

        public void update(EntityMoveableRollingStock stock, int hornTime, float hornPull) {
            if (hornTime < 1) {
                this.pullString = 0.0f;
                this.soundDampener = 0.0f;
                for (ISound chime : this.chimes) {
                    if (!chime.isPlaying()) continue;
                    chime.stop();
                }
            } else {
                float maxDelta = 0.05f;
                float delta = 0.0f;
                if (hornTime > 5) {
                    if ((double)this.soundDampener < 0.4) {
                        this.soundDampener = 0.4f;
                    }
                    if (this.soundDampener < 1.0f) {
                        this.soundDampener = (float)((double)this.soundDampener + 0.1);
                    }
                    delta = hornPull - this.pullString;
                } else {
                    if (this.soundDampener > 0.0f) {
                        this.soundDampener = (float)((double)this.soundDampener - 0.07);
                    }
                    delta = -this.pullString;
                }
                this.pullString = this.pullString == 0.0f ? (float)((double)this.pullString + (double)delta * 0.55) : (this.pullString += Math.max(Math.min(delta, maxDelta), -maxDelta));
                this.pullString = Math.min(this.pullString, (float)((Whistle)Whistle.this).quilling.maxPull);
                for (int i = 0; i < ((Whistle)Whistle.this).quilling.chimes.size(); ++i) {
                    ISound sound = this.chimes.get(i);
                    Quilling.Chime chime = ((Whistle)Whistle.this).quilling.chimes.get(i);
                    double perc = this.pullString;
                    perc = Math.min(perc, chime.pull_end);
                    perc -= chime.pull_start;
                    if ((perc /= chime.pull_end - chime.pull_start) > 0.0) {
                        double pitch = (chime.pitch_end - chime.pitch_start) * perc + chime.pitch_start;
                        sound.setPitch((float)pitch);
                        sound.setVolume((float)(perc * (double)this.soundDampener));
                        sound.setPosition(stock.getPosition());
                        sound.setVelocity(stock.getVelocity());
                        if (sound.isPlaying()) continue;
                        sound.play(stock.getPosition());
                        continue;
                    }
                    if (!sound.isPlaying()) continue;
                    sound.stop();
                }
            }
        }

        public void terminate() {
            if (this.chimes != null) {
                for (ISound chime : this.chimes) {
                    chime.stop();
                }
            }
        }
    }
}

