/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Interactable;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.ModCore;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.model.obj.OBJGroup;
import cam72cam.mod.render.GlobalRender;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.text.TextColor;
import cam72cam.mod.util.Axis;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.WordUtils;
import util.Matrix4;

public class Control<T extends EntityMoveableRollingStock>
extends Interactable<T> {
    public final String controlGroup;
    public final String label;
    public final boolean toggle;
    public final boolean press;
    public final boolean global;
    protected final boolean invert;
    protected final float offset;
    private final boolean hide;
    private final Vec3d center;
    protected final ModelState state;
    private final String modelId;
    private final boolean noInteract;
    private Vec3d rotationPoint = null;
    private float rotationDegrees = 0.0f;
    private final Map<Axis, Float> rotations = new HashMap<Axis, Float>();
    private final Map<Axis, Float> translations = new HashMap<Axis, Float>();
    private final Map<Axis, Float> scales = new HashMap<Axis, Float>();
    private final Map<Axis, Float> scaleRot = new HashMap<Axis, Float>();
    private Vec3d lastClientLook = null;

    public static <T extends EntityMoveableRollingStock> List<Control<T>> get(ComponentProvider provider, ModelState state, ModelComponentType type, ModelComponentType.ModelPosition pos) {
        return provider.parseAll(type, pos).stream().map(part1 -> new Control((ModelComponent)part1, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public static <T extends EntityMoveableRollingStock> List<Control<T>> get(ComponentProvider provider, ModelState state, ModelComponentType type) {
        return provider.parseAll(type).stream().map(part1 -> new Control((ModelComponent)part1, state, provider.internal_model_scale, provider.widgetConfig)).collect(Collectors.toList());
    }

    public Control(ModelComponent part, ModelState state, double internal_model_scale, Map<String, DataBlock> widgetConfig) {
        super(part);
        String rotpat = part.pos != null && !part.type.regex.contains("#POS#") ? part.type.regex.replaceAll("#ID#", part.pos + "_" + part.id + "_ROT") : (part.pos != null ? part.type.regex.replaceAll("#POS#", part.pos.toString()).replaceAll("#ID#", part.id + "_ROT") : part.type.regex.replaceAll("#ID#", part.id + "_ROT"));
        String name = rotpat.replace("_ROT", "").replaceAll("\\.\\*", "");
        DataBlock config = widgetConfig.containsKey(name) ? widgetConfig.get(name) : new DataBlock(){

            @Override
            public Map<String, DataBlock.Value> getValueMap() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, List<DataBlock.Value>> getValuesMap() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, DataBlock> getBlockMap() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, List<DataBlock>> getBlocksMap() {
                return Collections.emptyMap();
            }
        };
        this.controlGroup = config.getValue("CG").asString(part.modelIDs.stream().map(group -> {
            Matcher matcher = Pattern.compile("_CG_([^_]+)").matcher((CharSequence)group);
            return matcher.find() ? matcher.group(1) : null;
        }).filter(Objects::nonNull).findFirst().orElse(part.key));
        this.label = config.getValue("LABEL").asString(part.modelIDs.stream().map(group -> {
            Matcher matcher = Pattern.compile("_LABEL_([^_]+)").matcher((CharSequence)group);
            return matcher.find() ? matcher.group(1).replaceAll("\\^", " ") : null;
        }).filter(Objects::nonNull).findFirst().orElse(null));
        Predicate<String> hasKey = s -> config.getValue((String)s).asBoolean(part.modelIDs.stream().anyMatch(g -> g.contains("_" + s + "_") || g.startsWith(s + "_") || g.endsWith("_" + s)));
        this.toggle = hasKey.test("TOGGLE");
        this.press = hasKey.test("PRESS");
        this.global = hasKey.test("GLOBAL");
        this.invert = hasKey.test("INVERT");
        this.hide = hasKey.test("HIDE");
        this.noInteract = hasKey.test("NOTOUCH") || hasKey.test("NOINTERACT");
        this.offset = config.getValue("OFFSET").asFloat(part.modelIDs.stream().map(group -> {
            Matcher matcher = Pattern.compile("_OFFSET_([^_]+)").matcher((CharSequence)group);
            return matcher.find() ? Float.valueOf(Float.parseFloat(matcher.group(1))) : null;
        }).filter(Objects::nonNull).findFirst().orElse(Float.valueOf(0.0f)).floatValue());
        DataBlock rotBlock = config.getBlock("ROT");
        if (rotBlock != null) {
            this.rotationDegrees = rotBlock.getValue("DEGREES").asFloat().floatValue();
            DataBlock point = rotBlock.getBlock("POINT");
            this.rotationPoint = new Vec3d(point.getValue("X").asDouble().doubleValue(), point.getValue("Y").asDouble().doubleValue(), point.getValue("Z").asDouble().doubleValue());
            DataBlock axis = rotBlock.getBlock("AXIS");
            this.rotations.put(Axis.X, axis.getValue("X").asFloat());
            this.rotations.put(Axis.Y, axis.getValue("Y").asFloat());
            this.rotations.put(Axis.Z, axis.getValue("Z").asFloat());
            this.center = part.center;
        } else {
            OBJGroup rot = part.groups().stream().filter(g -> Pattern.matches(rotpat, g.name)).findFirst().orElse(null);
            if (rot != null && rot.normal != null) {
                this.rotationPoint = rot.max.add(rot.min).scale(0.5);
                Object[] split = rot.name.split("_");
                int idx = ArrayUtils.indexOf((Object[])split, (Object)"ROT");
                if (idx != -1) {
                    Object degrees = split[idx + 1];
                    try {
                        this.rotationDegrees = Float.parseFloat((String)degrees);
                    }
                    catch (NumberFormatException e) {
                        ModCore.error((String)"Unable to parse rotation point '%s': %s", (Object[])new Object[]{rot.name, e});
                    }
                }
                this.rotations.put(Axis.X, Float.valueOf((float)rot.normal.x));
                this.rotations.put(Axis.Y, Float.valueOf((float)rot.normal.y));
                this.rotations.put(Axis.Z, Float.valueOf((float)rot.normal.z));
                List nonRotGroups = part.groups().stream().filter(g -> !g.name.contains("_ROT")).map(g -> g.max.add(g.min).scale(0.5)).collect(Collectors.toList());
                this.center = nonRotGroups.isEmpty() ? part.center : nonRotGroups.stream().reduce(Vec3d.ZERO, Vec3d::add).scale(1.0 / (double)nonRotGroups.size());
            } else {
                this.center = part.center;
            }
        }
        DataBlock tl = config.getBlock("TL");
        if (tl != null) {
            tl.getValueMap().forEach((k, v) -> this.translations.put(Axis.valueOf((String)k), v.asFloat()));
        } else {
            Pattern pattern = Pattern.compile("TL_([^_]*)_([^_])");
            for (String modelID : part.modelIDs) {
                Matcher matcher = pattern.matcher(modelID);
                while (matcher.find()) {
                    this.translations.put(Axis.valueOf((String)matcher.group(2)), Float.valueOf(Float.parseFloat(matcher.group(1)) * (float)internal_model_scale));
                }
            }
        }
        DataBlock scale = config.getBlock("SCALE");
        if (scale != null) {
            scale.getValueMap().forEach((k, v) -> this.scales.put(Axis.valueOf((String)k), v.asFloat()));
            DataBlock r = scale.getBlock("R");
            if (r != null) {
                r.getValueMap().forEach((k, v) -> this.scaleRot.put(Axis.valueOf((String)k), v.asFloat()));
            }
        } else {
            Pattern pattern = Pattern.compile("SCALE_([^_]*)_([^_]+)");
            for (String modelID : part.modelIDs) {
                Matcher matcher = pattern.matcher(modelID);
                while (matcher.find()) {
                    if (matcher.group(2).startsWith("R")) {
                        this.scaleRot.put(Axis.valueOf((String)matcher.group(2).substring(1)), Float.valueOf(Float.parseFloat(matcher.group(1))));
                        continue;
                    }
                    this.scales.put(Axis.valueOf((String)matcher.group(2)), Float.valueOf(Float.parseFloat(matcher.group(1))));
                }
            }
        }
        if (this.hide) {
            state = state.push(builder -> builder.add((stock, group) -> this.getValue(stock) != 1.0f));
        }
        if (this.rotationPoint != null || !this.translations.isEmpty() || !this.scales.isEmpty()) {
            state = state.push(builder -> builder.add((stock, group, partialTicks) -> {
                Axis axis;
                float valuePercent = this.getValue(stock);
                Matrix4 m = new Matrix4();
                for (Map.Entry<Axis, Float> entry : this.translations.entrySet()) {
                    axis = entry.getKey();
                    Float val = entry.getValue();
                    m = m.translate(axis == Axis.X ? (double)(val.floatValue() * valuePercent) : 0.0, axis == Axis.Y ? (double)(val.floatValue() * valuePercent) : 0.0, axis == Axis.Z ? (double)(val.floatValue() * valuePercent) : 0.0);
                }
                if (this.rotationPoint != null) {
                    m = m.translate(this.rotationPoint.x, this.rotationPoint.y, this.rotationPoint.z);
                    m = m.rotate(Math.toRadians(valuePercent * this.rotationDegrees), (double)this.rotations.getOrDefault(Axis.X, Float.valueOf(0.0f)).floatValue(), (double)this.rotations.getOrDefault(Axis.Y, Float.valueOf(0.0f)).floatValue(), (double)this.rotations.getOrDefault(Axis.Z, Float.valueOf(0.0f)).floatValue());
                    m = m.translate(-this.rotationPoint.x, -this.rotationPoint.y, -this.rotationPoint.z);
                }
                if (!this.scales.isEmpty()) {
                    m = m.translate(part.center.x, part.center.y, part.center.z);
                    for (Map.Entry<Axis, Float> entry : this.scaleRot.entrySet()) {
                        axis = entry.getKey();
                        m = m.rotate(Math.toRadians(entry.getValue().floatValue()), axis == Axis.X ? 1.0 : 0.0, axis == Axis.Y ? 1.0 : 0.0, axis == Axis.Z ? 1.0 : 0.0);
                    }
                    m = m.scale(this.scales.containsKey(Axis.X) ? (double)(1.0f - this.scales.get(Axis.X).floatValue() + this.scales.get(Axis.X).floatValue() * valuePercent) : 1.0, this.scales.containsKey(Axis.Y) ? (double)(1.0f - this.scales.get(Axis.Y).floatValue() + this.scales.get(Axis.Y).floatValue() * valuePercent) : 1.0, this.scales.containsKey(Axis.Z) ? (double)(1.0f - this.scales.get(Axis.Z).floatValue() + this.scales.get(Axis.Z).floatValue() * valuePercent) : 1.0);
                    for (Map.Entry<Axis, Float> entry : this.scaleRot.entrySet()) {
                        axis = entry.getKey();
                        m = m.rotate(Math.toRadians(-entry.getValue().floatValue()), axis == Axis.X ? 1.0 : 0.0, axis == Axis.Y ? 1.0 : 0.0, axis == Axis.Z ? 1.0 : 0.0);
                    }
                    m = m.translate(-part.center.x, -part.center.y, -part.center.z);
                }
                return m;
            }));
        }
        this.state = state;
        this.state.include(part);
        this.modelId = (String)part.modelIDs.stream().findFirst().get();
    }

    @Override
    public boolean disabled() {
        return this.noInteract;
    }

    private static String formatLabel(ModelComponentType label) {
        return WordUtils.capitalizeFully((String)label.name().replace("_X", "").replaceAll("_CONTROL", "").replaceAll("_", " ").toLowerCase(Locale.ROOT));
    }

    public void postRender(T stock, RenderState state, float partialTicks) {
        if (!ConfigGraphics.interactiveComponentsOverlay) {
            return;
        }
        if (!((EntityRollingStock)((Object)stock)).playerCanDrag(MinecraftClient.getPlayer(), this)) {
            return;
        }
        if (MinecraftClient.getPlayer().getPosition().distanceTo(stock.getPosition()) > ((EntityRollingStock)((Object)stock)).getDefinition().getLength(((EntityMoveableRollingStock)((Object)stock)).gauge)) {
            return;
        }
        boolean isPressed = ((EntityRollingStock)((Object)stock)).getControlPressed(this);
        if (!isPressed && Math.abs(this.lookedAt - stock.getWorld().getTicks()) > 2L) {
            return;
        }
        Matrix4 m = this.state.getGroupMatrix((EntityMoveableRollingStock)((Object)stock), this.modelId, partialTicks);
        Vec3d pos = m == null ? this.center : m.apply(this.center);
        String labelstate = "";
        float percent = this.getValue((EntityMoveableRollingStock)((Object)stock)) - this.offset;
        switch (this.part.type) {
            case TRAIN_BRAKE_X: 
            case INDEPENDENT_BRAKE_X: {
                if (!((EntityRollingStock)((Object)stock)).getDefinition().isLinearBrakeControl()) break;
            }
            case THROTTLE_X: 
            case REVERSER_X: 
            case THROTTLE_BRAKE_X: 
            case BELL_CONTROL_X: 
            case WHISTLE_CONTROL_X: 
            case HORN_CONTROL_X: 
            case ENGINE_START_X: 
            case CYLINDER_DRAIN_CONTROL_X: {
                if (this.part.type == ModelComponentType.REVERSER_X) {
                    percent *= -2.0f;
                }
                if (this.toggle || this.press) {
                    labelstate = percent == 1.0f ? " (On)" : " (Off)";
                    break;
                }
                labelstate = String.format(" (%d%%)", (int)(percent * 100.0f));
                break;
            }
            default: {
                if (this.label == null || this.label.trim().isEmpty()) {
                    return;
                }
                labelstate = this.toggle || this.press ? (percent == 1.0f ? " (On)" : " (Off)") : String.format(" (%d%%)", (int)(percent * 100.0f));
            }
        }
        String str = (this.label != null ? this.label : Control.formatLabel(this.part.type)) + labelstate;
        if (isPressed) {
            str = TextColor.BOLD.wrap(str);
        }
        GlobalRender.drawText((String)str, (RenderState)state, (Vec3d)pos, (float)0.2f, (float)(180.0f - stock.getRotationYaw() - 90.0f));
    }

    public float getValue(EntityMoveableRollingStock stock) {
        float pos = stock.getControlPosition(this) + this.offset;
        return (this.invert ? 1.0f - pos : pos) - (this.part.type == ModelComponentType.REVERSER_X || this.part.type == ModelComponentType.THROTTLE_BRAKE_X ? 0.5f : 0.0f);
    }

    public Vec3d transform(Vec3d point, T stock) {
        float partialTicks = 0.0f;
        Matrix4 m = this.state.getGroupMatrix((EntityMoveableRollingStock)((Object)stock), this.modelId, partialTicks);
        m = m == null ? ((EntityRollingStock)((Object)stock)).getModelMatrix() : ((EntityRollingStock)((Object)stock)).getModelMatrix().multiply(m);
        return m.apply(point);
    }

    @Override
    public Vec3d center(EntityRollingStock stock) {
        return this.transform(this.part.center, (EntityMoveableRollingStock)stock);
    }

    @Override
    public IBoundingBox getBoundingBox(EntityRollingStock stock) {
        return IBoundingBox.from((Vec3d)this.transform(this.part.min, (EntityMoveableRollingStock)stock), (Vec3d)this.transform(this.part.max, (EntityMoveableRollingStock)stock));
    }

    public float clientMovementDelta(Player player, EntityRollingStock stockRaw) {
        if (this.press) {
            return 1.0f;
        }
        EntityMoveableRollingStock stock = (EntityMoveableRollingStock)stockRaw;
        float delta = 0.0f;
        Vec3d partPos = this.transform(this.center, stock).subtract(stock.getPosition());
        Vec3d current = player.getPositionEyes().subtract(stock.getPosition());
        Vec3d look = player.getLookVector();
        double len = 1.0 + current.add(look).distanceTo(partPos);
        current = current.add(look.scale(len));
        current = current.rotateYaw(stock.getRotationYaw());
        if (this.lastClientLook != null) {
            Vec3d movement = current.subtract(this.lastClientLook);
            movement = movement.rotateYaw(-stock.getRotationYaw());
            float applied = Math.min(0.1f, (float)(movement.length() * 1.0));
            if (this.rotationDegrees <= 180.0f) {
                float value = stock.getControlPosition(this);
                Vec3d grabComponent = this.transform(this.center, stock).add(movement);
                stock.setControlPosition(this, value + applied);
                Vec3d grabComponentNext = this.transform(this.center, stock);
                stock.setControlPosition(this, value - applied);
                Vec3d grabComponentPrev = this.transform(this.center, stock);
                stock.setControlPosition(this, value);
                delta = grabComponent.distanceTo(grabComponentNext) < grabComponent.distanceTo(grabComponentPrev) ? (float)((double)delta + (double)applied * movement.length() / grabComponent.distanceTo(grabComponentNext)) : (float)((double)delta - (double)applied * movement.length() / grabComponent.distanceTo(grabComponentPrev));
            } else {
                delta = movement.x * (1.0 - this.rotationPoint.x) + movement.y * (1.0 - this.rotationPoint.y) + movement.z * (1.0 - this.rotationPoint.z) > 0.0 ? (delta += applied) : (delta -= applied);
            }
        }
        this.lastClientLook = current;
        return Float.isNaN(delta) ? 0.0f : delta;
    }

    public void stopClientDragging() {
        this.lastClientLook = null;
    }

    public void effects(T stock) {
        EntityRollingStockDefinition.ControlSoundsDefinition sounds = ((EntityRollingStock)((Object)stock)).getDefinition().getControlSound(this.part.type.name().replace("_X", "_" + this.part.id));
        if (sounds != null) {
            sounds.effects((EntityRollingStock)((Object)stock), ((EntityRollingStock)((Object)stock)).getControlPressed(this), ((EntityRollingStock)((Object)stock)).getControlPosition(this), this.center((EntityRollingStock)((Object)stock)));
        }
    }

    public void removed(T stock) {
        EntityRollingStockDefinition.ControlSoundsDefinition sounds = ((EntityRollingStock)((Object)stock)).getDefinition().getControlSound(this.part.type.name().replace("_X", "_" + this.part.id));
        if (sounds != null) {
            sounds.removed(stock);
        }
    }
}

