/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.library;

import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapped;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.text.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

@TagMapped(value=TagMapper.class)
public class Gauge {
    public static final double STANDARD = 1.435;
    private final double gauge;
    private final String name;
    private static List<Gauge> gauges = new ArrayList<Gauge>();

    Gauge(double gauge, String name) {
        this.gauge = gauge;
        this.name = name;
    }

    public double value() {
        return this.gauge;
    }

    public double scale() {
        return this.gauge / 1.435;
    }

    public String toString() {
        return TextUtil.translate((String)("immersiverailroading:gauge." + this.name.toLowerCase(Locale.ROOT)));
    }

    public boolean equals(Object o) {
        return o instanceof Gauge && ((Gauge)o).gauge == this.gauge;
    }

    public boolean isModel() {
        return this.value() < 0.3;
    }

    public static List<Gauge> values() {
        return new ArrayList<Gauge>(gauges);
    }

    public static void reset() {
        gauges = new ArrayList<Gauge>();
    }

    public static void register(double gauge, String name) {
        Gauge.remove(gauge);
        gauges.add(new Gauge(gauge, name));
        gauges.sort(new Comparator<Gauge>(){

            @Override
            public int compare(Gauge arg0, Gauge arg1) {
                return Double.compare(arg1.gauge, arg0.gauge);
            }
        });
    }

    public static void remove(double gauge) {
        for (int i = 0; i < gauges.size(); ++i) {
            if (gauges.get(i).value() != gauge) continue;
            gauges.remove(i);
            break;
        }
    }

    public static Gauge from(double gauge) {
        Gauge closest = gauges.get(0);
        for (Gauge g : gauges) {
            if (g.gauge == gauge) {
                return g;
            }
            if (!(Math.abs(g.value() - gauge) < Math.abs(closest.value() - gauge))) continue;
            closest = g;
        }
        return closest;
    }

    public static Gauge standard() {
        return Gauge.from(1.435);
    }

    public boolean shouldSit() {
        return this.gauge <= 0.632;
    }

    static class TagMapper
    implements cam72cam.mod.serialization.TagMapper<Gauge> {
        TagMapper() {
        }

        public TagMapper.TagAccessor<Gauge> apply(Class<Gauge> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, g) -> d.setDouble(fieldName, g == null ? null : Double.valueOf(g.value())), d -> d.hasKey(fieldName) ? Gauge.from(d.getDouble(fieldName)) : null);
        }
    }
}

