/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.gui.components.ListSelector;
import cam72cam.immersiverailroading.items.ItemPaintBrush;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.PaintBrushMode;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.gui.screen.Slider;
import cam72cam.mod.render.opengl.RenderState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import util.Matrix4;

public class PaintBrushPicker
implements IScreen {
    private EntityMoveableRollingStock stock;
    private String variant;
    private double zoom = 1.0;
    private long frame;

    public void init(final IScreenBuilder screen) {
        this.frame = 0L;
        Entity ent = MinecraftClient.getEntityMouseOver();
        if (ent == null) {
            screen.close();
            return;
        }
        this.stock = (EntityMoveableRollingStock)ent.as(EntityMoveableRollingStock.class);
        if (this.stock == null) {
            screen.close();
        }
        this.variant = this.stock.getTexture();
        int xtop = -GUIHelpers.getScreenWidth() / 2;
        int ytop = -GUIHelpers.getScreenHeight() / 4;
        int width = 200;
        int height = 20;
        new ListSelector<String>(screen, 0, width, height, this.variant, (Map)this.stock.getDefinition().textureNames.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(String option) {
                PaintBrushPicker.this.variant = option;
            }
        }.setVisible(true);
        Slider zoom_slider = new Slider(screen, xtop + width, (int)((double)GUIHelpers.getScreenHeight() * 0.75 - (double)height), "Zoom: ", 0.1, 2.0, 1.0, true){

            public void onSlider() {
                PaintBrushPicker.this.zoom = this.getValue();
            }
        };
        width = 80;
        Button random = new Button(screen, GUIHelpers.getScreenWidth() / 2 - width, ytop, width, height, "Random"){

            public void onClick(Player.Hand hand) {
                PaintBrushPicker.this.variant = ItemPaintBrush.nextRandomTexture(PaintBrushPicker.this.stock, PaintBrushPicker.this.variant);
            }
        };
        Button apply = new Button(screen, GUIHelpers.getScreenWidth() / 2 - width, (int)((double)GUIHelpers.getScreenHeight() * 0.75 - (double)(height * 2)), width, height, "Apply to Stock"){

            public void onClick(Player.Hand hand) {
                new ItemPaintBrush.PaintBrushPacket(PaintBrushPicker.this.stock, PaintBrushMode.GUI, PaintBrushPicker.this.variant, false).sendToServer();
                screen.close();
            }
        };
        Button apply_connected = new Button(screen, GUIHelpers.getScreenWidth() / 2 - width, (int)((double)GUIHelpers.getScreenHeight() * 0.75 - (double)height), width, height, "Apply to Train"){

            public void onClick(Player.Hand hand) {
                new ItemPaintBrush.PaintBrushPacket(PaintBrushPicker.this.stock, PaintBrushMode.GUI, PaintBrushPicker.this.variant, true).sendToServer();
                screen.close();
            }
        };
    }

    public void onEnterKey(IScreenBuilder builder) {
        new ItemPaintBrush.PaintBrushPacket(this.stock, PaintBrushMode.GUI, this.variant, false).sendToServer();
        builder.close();
    }

    public void onClose() {
    }

    public void draw(IScreenBuilder builder, RenderState state) {
        String current;
        ++this.frame;
        double textScale = 1.5;
        GUIHelpers.drawRect((int)200, (int)0, (int)(GUIHelpers.getScreenWidth() - 200), (int)GUIHelpers.getScreenHeight(), (int)-872415232);
        GUIHelpers.drawRect((int)0, (int)0, (int)200, (int)GUIHelpers.getScreenHeight(), (int)-301989888);
        String string = current = this.variant == null ? null : this.variant + "";
        if (current == null || current.isEmpty()) {
            current = this.stock.getDefinition().textureNames.keySet().stream().findFirst().orElse(null);
        }
        current = current == null ? ChatText.BRUSH_NO_VARIANTS.toString() : this.stock.getDefinition().textureNames.getOrDefault(current, "Unknown");
        current = GuiText.TEXTURE_TOOLTIP.toString(current);
        GUIHelpers.drawCenteredString((String)this.stock.getDefinition().name(), (int)((int)((double)(200 + (GUIHelpers.getScreenWidth() - 200) / 2) / textScale)), (int)((int)(40.0 / textScale)), (int)0xFFFFFF, (Matrix4)new Matrix4().scale(textScale, textScale, textScale));
        GUIHelpers.drawCenteredString((String)current, (int)((int)((double)(200 + (GUIHelpers.getScreenWidth() - 200) / 2) / textScale)), (int)((int)((double)(GUIHelpers.getScreenHeight() - 60) / textScale)), (int)0xFFFFFF, (Matrix4)new Matrix4().scale(textScale, textScale, textScale));
        StockModel<?, ?> model = this.stock.getDefinition().getModel();
        int scale = (int)((double)(GUIHelpers.getScreenWidth() / 40) * this.zoom);
        float speed = 0.75f;
        state.translate((double)(200 + (GUIHelpers.getScreenWidth() - 200) / 2), (double)(builder.getHeight() / 2 + 10), 400.0);
        state.rotate((double)((float)this.stock.getTickCount() * speed % 360.0f), 0.0, 1.0, 0.0);
        state.scale((double)(-scale), (double)(-scale), (double)(-scale));
        state.lightmap(1.0f, 1.0f);
        double prevDist = this.stock.distanceTraveled;
        String prevTex = this.stock.getTexture();
        Gauge prevGauge = this.stock.gauge;
        this.stock.setTexture(this.variant);
        this.stock.distanceTraveled += (double)this.frame * 0.02;
        this.stock.gauge = Gauge.standard();
        model.renderEntity(this.stock, state, 0.0f);
        model.postRenderEntity(this.stock, state, 0.0f);
        this.stock.setTexture(prevTex);
        this.stock.distanceTraveled = prevDist;
        this.stock.gauge = prevGauge;
    }
}

