/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.core.multiblock.rectangular;

import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockTileEntityBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.PartPosition;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockTileEntityBase {
    PartPosition position = PartPosition.Unknown;
    ForgeDirection outwards = ForgeDirection.UNKNOWN;

    public ForgeDirection getOutwardsDir() {
        return this.outwards;
    }

    public PartPosition getPartPosition() {
        return this.position;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        CoordTriplet maxCoord = controller.getMaximumCoord();
        CoordTriplet minCoord = controller.getMinimumCoord();
        this.recalculateOutwardsDirection(minCoord, maxCoord);
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwards = ForgeDirection.UNKNOWN;
    }

    public void recalculateOutwardsDirection(CoordTriplet minCoord, CoordTriplet maxCoord) {
        this.outwards = ForgeDirection.UNKNOWN;
        this.position = PartPosition.Unknown;
        int facesMatching = 0;
        if (maxCoord.x == this.field_145851_c || minCoord.x == this.field_145851_c) {
            ++facesMatching;
        }
        if (maxCoord.y == this.field_145848_d || minCoord.y == this.field_145848_d) {
            ++facesMatching;
        }
        if (maxCoord.z == this.field_145849_e || minCoord.z == this.field_145849_e) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.Interior;
        } else if (facesMatching >= 3) {
            this.position = PartPosition.FrameCorner;
        } else if (facesMatching == 2) {
            this.position = PartPosition.Frame;
        } else if (maxCoord.x == this.field_145851_c) {
            this.position = PartPosition.EastFace;
            this.outwards = ForgeDirection.EAST;
        } else if (minCoord.x == this.field_145851_c) {
            this.position = PartPosition.WestFace;
            this.outwards = ForgeDirection.WEST;
        } else if (maxCoord.z == this.field_145849_e) {
            this.position = PartPosition.SouthFace;
            this.outwards = ForgeDirection.SOUTH;
        } else if (minCoord.z == this.field_145849_e) {
            this.position = PartPosition.NorthFace;
            this.outwards = ForgeDirection.NORTH;
        } else if (maxCoord.y == this.field_145848_d) {
            this.position = PartPosition.TopFace;
            this.outwards = ForgeDirection.UP;
        } else {
            this.position = PartPosition.BottomFace;
            this.outwards = ForgeDirection.DOWN;
        }
    }

    public abstract void isGoodForFrame() throws MultiblockValidationException;

    public abstract void isGoodForSides() throws MultiblockValidationException;

    public abstract void isGoodForTop() throws MultiblockValidationException;

    public abstract void isGoodForBottom() throws MultiblockValidationException;

    public abstract void isGoodForInterior() throws MultiblockValidationException;
}

