/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemUtils {
    public static final Item EMPTY_ITEM = null;
    public static final ItemStack EMPTY_STACK = new ItemStack(EMPTY_ITEM);
    private static final List<Item> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM);

    public static ItemStack getStackFrom(Object data) {
        ItemStack itemStack = null;
        if (data != null) {
            if (data instanceof Block) {
                Block block = (Block)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof Item) {
                Item item = (Item)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof ItemStack) {
                ItemStack stack;
                itemStack = stack = (ItemStack)data;
            }
        }
        return itemStack;
    }

    public static Item getItemFromStack(ItemStack stack) {
        return stack != null ? stack.func_77973_b() : EMPTY_ITEM;
    }

    public static int getStackCount(ItemStack stack) {
        return stack != null ? stack.field_77994_a : 0;
    }

    public static int getStackDamage(ItemStack stack) {
        return stack != null ? stack.func_77960_j() : 0;
    }

    public static boolean isItemEmpty(Object data) {
        ItemStack stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static ItemStack getDefaultInstance(Block block) {
        return new ItemStack(block);
    }

    public static ItemStack getDefaultInstance(Item item) {
        return new ItemStack(item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        ItemStack stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = StringUtils.getOrDefault(stack.func_82833_r());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

