/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ding.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@Mod(modid="Ding", name="Ding", version="MC1.7.10v2", acceptableRemoteVersions="*")
public class Ding {
    public static final String version = "MC1.7.10v2";
    public static String name = "random.orb";
    public static double pitch = 1.0;
    public static String nameWorld = "random.orb";
    public static double pitchWorld = 1.0;
    public static int playOn = 1;
    @Mod.Instance(value="Ding")
    public static Ding instance;
    public static boolean played;
    public static boolean playWorld;
    public static int playMC;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            LogManager.getLogger((String)"Ding").log(Level.INFO, "Ding is a clientside mod only!");
        }
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        name = this.addCommentAndReturnString(config, "ding", "name", "Minecraft name of sound file to play when Minecraft is loaded\nEG: \"gui.button.press\" or \"random.orb\"\n\nThis can also be a mod sound if the mod is installed.\nEG: modname:modsound.boing", "random.orb");
        pitch = this.addCommentAndReturnDouble(config, "ding", "pitch", "Pitch of the sound to play when Minecraft is loaded", 1.0);
        nameWorld = this.addCommentAndReturnString(config, "ding", "nameWorld", "Minecraft name of sound file to play when world is loaded\nEG: \"gui.button.press\" or \"random.orb\"\n\nThis can also be a mod sound if the mod is installed.\nEG: modname:modsound.boing", "random.orb");
        pitchWorld = this.addCommentAndReturnDouble(config, "ding", "pitchWorld", "Pitch of the sound to play when world is loaded", 1.0);
        playOn = this.addCommentAndReturnInt(config, "ding", "playOn", "Play sound on...\n0 = Nothing (why install the mod though?)\n1 = MC load\n2 = World load\n3 = MC and World load", 1);
        config.save();
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu && !played) {
            played = true;
            if (playOn == 1 || playOn == 3) {
                playMC = 10;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        playWorld = true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (playWorld && event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70173_aa > 20) {
            playWorld = false;
            if (playOn == 2 || playOn == 3) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(nameWorld), (float)((float)pitchWorld)));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (playMC > 0 && event.phase == TickEvent.Phase.END && --playMC == 0) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(name), (float)((float)pitch)));
        }
    }

    public int addCommentAndReturnInt(Configuration config, String cat, String s, String comment, int i) {
        Property prop = config.get(cat, s, i);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getInt();
    }

    public double addCommentAndReturnDouble(Configuration config, String cat, String s, String comment, double d) {
        Property prop = config.get(cat, s, d);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getDouble();
    }

    public String addCommentAndReturnString(Configuration config, String cat, String s, String comment, String val) {
        Property prop = config.get(cat, s, val);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    static {
        played = false;
        playWorld = false;
        playMC = 0;
    }
}

