/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.util;

import cpw.mods.fml.common.eventhandler.Event;
import goldenapple.rfdrills.item.IEnergyTool;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ToolHelper {
    public static boolean isToolEffective(ItemStack stack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        return ToolHelper.isToolEffective(stack, block, world.func_72805_g(x, y, z)) || block.func_149712_f(world, x, y, z) == 0.0f;
    }

    public static boolean isToolEffective(ItemStack stack, Block block, int meta) {
        if (block == null) {
            return false;
        }
        if (stack != null) {
            for (String toolClass : stack.func_77973_b().getToolClasses(stack)) {
                if (!toolClass.equals(block.getHarvestTool(meta))) continue;
                return stack.func_77973_b().getHarvestLevel(stack, toolClass) >= block.getHarvestLevel(meta);
            }
            return stack.func_77973_b().canHarvestBlock(block, stack);
        }
        return false;
    }

    public static void drainEnergy(ItemStack stack, EntityPlayer player, int energy) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        IEnergyTool tool = (IEnergyTool)stack.func_77973_b();
        tool.drainEnergy(stack, energy);
        player.func_70062_b(0, stack);
        if (tool.getEnergyStored(stack) <= 0 && tool.getTier((ItemStack)stack).canBreak) {
            player.func_70669_a(stack);
            player.func_71028_bD();
            player.func_71064_a(StatList.field_75930_F[Item.func_150891_b((Item)stack.func_77973_b())], 1);
        }
    }

    public static void harvestBlock(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        if (!ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)player, (Block)block, (boolean)ToolHelper.isToolEffective(player.func_71045_bC(), world, x, y, z)) && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                if (!player.field_71075_bZ.field_75098_d && world.func_82736_K().func_82766_b("doTileDrops")) {
                    block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                    block.func_149657_c(world, x, y, z, event.getExpToDrop());
                }
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + meta << 12);
            }
        } else if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
            block.func_149664_b(world, x, y, z, meta);
        }
    }

    public static boolean hoeBlock(ItemStack stack, World world, int x, int y, int z, int sideHit, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (sideHit != 0 && world.func_147437_c(x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d) && player.func_82247_a(x, y, z, sideHit, stack)) {
            if (!world.field_72995_K) {
                world.func_147449_b(x, y, z, Blocks.field_150458_ak);
            }
            return true;
        }
        return false;
    }
}

