/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.util;

import cofh.core.key.IKeyBinding;
import goldenapple.rfdrills.item.soulupgrade.AbstractSoulUpgrade;
import goldenapple.rfdrills.item.soulupgrade.SoulUpgradeHelper;
import java.util.Locale;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class StringHelper {
    public static String formatEnergy(int energy) {
        if (energy >= 10000000) {
            return String.format(Locale.US, "%.1fM", Float.valueOf((float)energy / 1000000.0f));
        }
        if (energy >= 10000) {
            return String.format(Locale.US, "%.1fk", Float.valueOf((float)energy / 1000.0f));
        }
        return Integer.toString(energy);
    }

    public static String writeUpgradeInfo(ItemStack itemStack, AbstractSoulUpgrade upgrade) {
        return StringHelper.writeUpgradeInfo(SoulUpgradeHelper.getUpgradeLevel(itemStack, upgrade), upgrade);
    }

    public static String writeUpgradeInfo(int level, AbstractSoulUpgrade upgrade) {
        String upgradeName = StatCollector.func_74838_a((String)("rfdrills.upgrade." + upgrade.getUnlocalizedName()));
        if (level == 1) {
            return upgradeName;
        }
        String levelName = StatCollector.func_74838_a((String)("rfdrills.level." + level));
        return upgradeName + " " + levelName;
    }

    public static String writeEnergyPerBlockInfo(int energy, boolean green) {
        String energyFormatted = (green ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + StringHelper.formatEnergy(energy) + EnumChatFormatting.RESET;
        return StatCollector.func_74837_a((String)"rfdrills.energy_per_block.tooltip", (Object[])new Object[]{energyFormatted});
    }

    public static String writeEnergyPerBlockInfo(int energy) {
        String energyFormatted = StringHelper.formatEnergy(energy);
        return StatCollector.func_74837_a((String)"rfdrills.energy_per_block.tooltip", (Object[])new Object[]{energyFormatted});
    }

    public static String writeEnergyInfo(int energyLevel, int maxEnergy) {
        String energy1 = StringHelper.formatEnergy(energyLevel);
        String energy2 = StringHelper.formatEnergy(maxEnergy);
        return StatCollector.func_74838_a((String)"info.cofh.charge") + String.format(": %s / %s RF", energy1, energy2);
    }

    private static String writeModeSwitchInfo(String unlocalizedName, int key) {
        return StatCollector.func_74837_a((String)unlocalizedName, (Object[])new Object[]{cofh.lib.util.helpers.StringHelper.getKeyName((int)key)});
    }

    public static String writeModeSwitchInfo(String unlocalizedName, KeyBinding keyBinding) {
        return StringHelper.writeModeSwitchInfo(unlocalizedName, keyBinding.func_151463_i());
    }

    public static String writeModeSwitchInfo(String unlocalizedName, IKeyBinding keyBinding) {
        return StringHelper.writeModeSwitchInfo(unlocalizedName, keyBinding.getKey());
    }
}

