/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.item;

import cofh.api.item.IEmpowerableItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.key.IKeyBinding;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.BlockHelper;
import cofh.repack.codechicken.lib.math.MathHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import goldenapple.rfdrills.RFDrills;
import goldenapple.rfdrills.config.ConfigHandler;
import goldenapple.rfdrills.item.EnumModType;
import goldenapple.rfdrills.item.IEnergyTool;
import goldenapple.rfdrills.item.ToolTier;
import goldenapple.rfdrills.item.soulupgrade.AbstractSoulUpgrade;
import goldenapple.rfdrills.item.soulupgrade.SoulUpgradeHelper;
import goldenapple.rfdrills.item.soulupgrade.SoulUpgrades;
import goldenapple.rfdrills.util.LogHelper;
import goldenapple.rfdrills.util.MiscUtil;
import goldenapple.rfdrills.util.StringHelper;
import goldenapple.rfdrills.util.ToolHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSoulCrusher
extends ItemTool
implements IEnergyTool,
IEqualityOverrideItem,
IEmpowerableItem {
    private static final Set<Material> effectiveMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151596_z, Material.field_151592_s, Material.field_151566_D, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151597_y, Material.field_151573_f, Material.field_151576_e, Material.field_151595_p, Material.field_151589_v, Material.field_151575_d, Material.field_151580_n, Material.field_151572_C});
    private static ToolTier tier = ToolTier.SOUL_CRUSHER;

    public ItemSoulCrusher() {
        super(1.0f, ItemSoulCrusher.tier.material, null);
        this.setHarvestLevel("pickaxe", ItemSoulCrusher.tier.material.func_77996_d());
        this.setHarvestLevel("shovel", ItemSoulCrusher.tier.material.func_77996_d());
        this.setHarvestLevel("axe", ItemSoulCrusher.tier.material.func_77996_d());
        this.func_77637_a(RFDrills.RFDrillsTab);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUseWithMode(stack) && effectiveMaterials.contains(block.func_149688_o());
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUseWithMode(stack) && effectiveMaterials.contains(block.func_149688_o()) ? this.field_77864_a : 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass) && this.getEnergyStored(stack) >= this.getEnergyPerUseWithMode(stack)) {
            return super.getHarvestLevel(stack, toolClass);
        }
        return -1;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack, block, meta) && ToolHelper.isToolEffective(stack, block, meta)) {
            switch (this.getMode(stack)) {
                case 0: {
                    return this.field_77864_a;
                }
                case 1: 
                case 2: {
                    return this.field_77864_a / 3.0f;
                }
                case 3: {
                    return this.field_77864_a / 6.0f;
                }
            }
            LogHelper.warn("Illegal drill mode!", new Object[0]);
            return this.field_77864_a;
        }
        return 1.0f;
    }

    private int getEnergyPerUse(ItemStack stack) {
        return Math.round(ItemSoulCrusher.tier.energyPerBlock / (EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack) + 1));
    }

    private int getEnergyPerUseWithMode(ItemStack stack) {
        int energy = this.getEnergyPerUse(stack);
        switch (this.getMode(stack)) {
            case 0: {
                break;
            }
            case 1: {
                energy *= 3;
                break;
            }
            case 2: {
                energy *= 5;
                break;
            }
            case 3: {
                energy *= 10;
                break;
            }
            default: {
                LogHelper.warn("Illegal drill mode!", new Object[0]);
            }
        }
        return energy;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(this.setEnergy(new ItemStack(item), 0));
        ItemStack upgradedStack = new ItemStack(item);
        upgradedStack = SoulUpgradeHelper.applyUpgrade(upgradedStack, SoulUpgrades.upgradeEmpowered, (byte)2);
        upgradedStack = SoulUpgradeHelper.applyUpgrade(upgradedStack, SoulUpgrades.upgradeBeastMode, (byte)2);
        upgradedStack = SoulUpgradeHelper.applyUpgrade(upgradedStack, SoulUpgrades.upgradeFork, (byte)1);
        list.add(this.setEnergy(upgradedStack, this.getMaxEnergyStored(upgradedStack)));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ItemSoulCrusher.tier.rarity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack), 0.0);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && this.getEnergyStored(stack) > 0) {
            int xRadius = 0;
            int yRadius = 0;
            int zRadius = 0;
            switch (this.getMode(stack)) {
                case 1: {
                    if (BlockHelper.getCurrentMousedOverSide((EntityPlayer)player) == 0 || BlockHelper.getCurrentMousedOverSide((EntityPlayer)player) == 1) {
                        switch (MathHelper.floor_double((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                            case 0: {
                                zRadius = 1;
                                break;
                            }
                            case 1: {
                                xRadius = 1;
                                break;
                            }
                            case 2: {
                                zRadius = 1;
                                break;
                            }
                            case 3: {
                                xRadius = 1;
                            }
                        }
                        break;
                    }
                    yRadius = 1;
                    break;
                }
                case 2: {
                    xRadius = 1;
                    yRadius = 1;
                    zRadius = 1;
                    break;
                }
                case 3: {
                    xRadius = 2;
                    yRadius = 2;
                    zRadius = 2;
                }
            }
            for (int a = x - xRadius; a <= x + xRadius; ++a) {
                for (int b = y - yRadius; b <= y + yRadius; ++b) {
                    for (int c = z - zRadius; c <= z + zRadius; ++c) {
                        if (!world.func_72899_e(a, b, c) || world.func_147437_c(a, b, c) || a == x && b == y && c == z) continue;
                        ToolHelper.harvestBlock(world, a, b, c, player);
                    }
                }
            }
        }
        ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)));
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityAttacked, EntityLivingBase entityAttacker) {
        if (entityAttacker instanceof EntityPlayer) {
            ToolHelper.drainEnergy(stack, (EntityPlayer)entityAttacker, this.getEnergyPerUse(stack) * 2);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af() && MiscUtil.shouldModeShiftClick(this)) {
            this.setEmpoweredState(stack, !this.isEmpowered(stack));
            this.onStateChange(player, stack);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ) {
        if (this.getEnergyStored(stack) == 0) {
            return false;
        }
        if (SoulUpgradeHelper.getUpgradeLevel(stack, SoulUpgrades.upgradeFork) == 0) {
            return false;
        }
        if (!ToolHelper.hoeBlock(stack, world, x, y, z, sideHit, player)) {
            return false;
        }
        int xRadius = 0;
        int zRadius = 0;
        switch (this.getMode(stack)) {
            case 1: {
                switch (MathHelper.floor_double((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                    case 0: {
                        zRadius = 1;
                        break;
                    }
                    case 1: {
                        xRadius = 1;
                        break;
                    }
                    case 2: {
                        zRadius = 1;
                        break;
                    }
                    case 3: {
                        xRadius = 1;
                    }
                }
                break;
            }
            case 2: {
                xRadius = 1;
                zRadius = 1;
                break;
            }
            case 3: {
                xRadius = 2;
                zRadius = 2;
            }
        }
        for (int a = x - xRadius; a <= x + xRadius; ++a) {
            for (int c = z - zRadius; c <= z + zRadius; ++c) {
                if (a == x && c == z) continue;
                ToolHelper.hoeBlock(stack, world, a, y, c, sideHit, player);
            }
        }
        ToolHelper.drainEnergy(stack, player, this.getEnergyPerUseWithMode(stack));
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean wtf) {
        list.add(StringHelper.writeEnergyInfo(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
        if (MiscUtil.isShiftPressed()) {
            for (Map.Entry<AbstractSoulUpgrade, Byte> entry : SoulUpgradeHelper.getUpgrades(stack).entrySet()) {
                list.add(EnumChatFormatting.DARK_AQUA.toString() + StringHelper.writeUpgradeInfo(entry.getValue().byteValue(), entry.getKey()));
                entry.getKey().addDescription(stack, list);
            }
            boolean printedOneRecipeMessage = false;
            for (AbstractSoulUpgrade upgrade : SoulUpgrades.registry) {
                if (!upgrade.isUpgradeAvailable(stack)) continue;
                if (!printedOneRecipeMessage) {
                    list.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"rfdrills.soul_upgrade.recipe"));
                    printedOneRecipeMessage = true;
                }
                list.add(EnumChatFormatting.DARK_AQUA.toString() + StringHelper.writeUpgradeInfo(SoulUpgradeHelper.getUpgradeLevel(stack, upgrade) + 1, upgrade));
                upgrade.addRecipeDescription(stack, list);
            }
            if (ItemSoulCrusher.tier.hasModes) {
                if (ConfigHandler.modeShiftClickEIO) {
                    list.add(StatCollector.func_74838_a((String)"rfdrills.drill_has_modes.sneak.tooltip"));
                } else {
                    list.add(StringHelper.writeModeSwitchInfo("rfdrills.drill_has_modes.tooltip", (IKeyBinding)KeyBindingEmpower.instance));
                }
            }
            if (MiscUtil.isItemSilent(stack)) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.silent.tooltip"));
            }
        } else {
            for (Map.Entry<AbstractSoulUpgrade, Byte> entry : SoulUpgradeHelper.getUpgrades(stack).entrySet()) {
                list.add(EnumChatFormatting.DARK_AQUA.toString() + StringHelper.writeUpgradeInfo(entry.getValue().byteValue(), entry.getKey()));
            }
            list.add(cofh.lib.util.helpers.StringHelper.shiftForDetails());
        }
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("rfdrills".toLowerCase() + ":" + "soul_crusher");
    }

    public String func_77658_a() {
        return "item." + "rfdrills".toLowerCase() + ":" + "soul_crusher";
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + "rfdrills".toLowerCase() + ":" + "soul_crusher";
    }

    public int getMode(ItemStack stack) {
        if (!ItemSoulCrusher.tier.hasModes) {
            return 0;
        }
        if (stack.field_77990_d == null) {
            return 0;
        }
        if (stack.field_77990_d.func_74764_b("Mode")) {
            return stack.field_77990_d.func_74771_c("Mode");
        }
        return 0;
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (this.getEnergyStored(stack) == 0) {
            return false;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74774_a("Mode", (byte)mode);
        return true;
    }

    private int getNumModes(ItemStack stack) {
        return SoulUpgradeHelper.getUpgradeLevel(stack, SoulUpgrades.upgradeBeastMode) + 1;
    }

    @Override
    public ToolTier getTier(ItemStack stack) {
        return ToolTier.FLUX_CRUSHER;
    }

    @Override
    public ItemStack setEnergy(ItemStack stack, int energy) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", Math.min(energy, this.getMaxEnergyStored(stack)));
        return stack;
    }

    @Override
    public ItemStack drainEnergy(ItemStack stack, int energy) {
        return this.setEnergy(stack, Math.max(0, this.getEnergyStored(stack) - energy));
    }

    @Override
    public int getEnergyPerUse(ItemStack stack, Block block, int meta) {
        return this.getEnergyPerUseWithMode(stack);
    }

    @Override
    public String writeModeInfo(ItemStack stack) {
        switch (this.getMode(stack)) {
            case 0: {
                return StatCollector.func_74838_a((String)"rfdrills.1x1x1.mode");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"rfdrills.1x3x1.mode");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"rfdrills.3x3x3.mode");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"rfdrills.5x5x5.mode");
            }
        }
        LogHelper.warn("Illegal drill mode!", new Object[0]);
        return StatCollector.func_74838_a((String)"rfdrills.1x1x1.mode");
    }

    @Override
    public EnumModType getModType() {
        return EnumModType.EIO;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int rechargeRate = ItemSoulCrusher.tier.rechargeRate;
        switch (SoulUpgradeHelper.getUpgradeLevel(stack, SoulUpgrades.upgradeEmpowered)) {
            case 1: {
                rechargeRate = 750;
                break;
            }
            case 2: {
                rechargeRate = 1500;
                break;
            }
            case 3: {
                rechargeRate = 5000;
            }
        }
        int energy = this.getEnergyStored(stack);
        int energyReceived = Math.min(this.getMaxEnergyStored(stack) - energy, Math.min(rechargeRate, maxReceive));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74764_b("Energy")) {
            return stack.field_77990_d.func_74762_e("Energy");
        }
        stack.field_77990_d.func_74768_a("Energy", 0);
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        switch (SoulUpgradeHelper.getUpgradeLevel(stack, SoulUpgrades.upgradeEmpowered)) {
            case 0: {
                return ItemSoulCrusher.tier.maxEnergy;
            }
            case 1: {
                return 500000;
            }
            case 2: {
                return 1000000;
            }
            case 3: {
                return 5000000;
            }
        }
        return ItemSoulCrusher.tier.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack current, ItemStack previous) {
        return current.func_77973_b() == previous.func_77973_b();
    }

    public boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == this.getNumModes(stack);
    }

    public boolean setEmpoweredState(ItemStack stack, boolean b) {
        if (!ItemSoulCrusher.tier.hasModes) {
            return false;
        }
        if (this.getMode(stack) == this.getNumModes(stack)) {
            this.setMode(stack, 0);
        } else {
            this.setMode(stack, this.getMode(stack) + 1);
        }
        return true;
    }

    public void onStateChange(EntityPlayer player, ItemStack stack) {
        if (!MiscUtil.isItemSilent(stack)) {
            if (this.getMode(stack) == 0) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.6f);
            } else {
                player.field_70170_p.func_72956_a((Entity)player, "ambient.weather.thunder", 0.4f, 1.0f);
            }
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(this.writeModeInfo(stack)));
    }
}

