/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goldenapple.rfdrills.RFDrills;
import goldenapple.rfdrills.item.EnumModType;
import goldenapple.rfdrills.item.IEnergyTool;
import goldenapple.rfdrills.item.ToolTier;
import goldenapple.rfdrills.util.LogHelper;
import goldenapple.rfdrills.util.MiscUtil;
import goldenapple.rfdrills.util.StringHelper;
import goldenapple.rfdrills.util.ToolHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemFluxHoe
extends ItemTool
implements IEnergyTool {
    public static final Set<Material> effectiveMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151584_j, Material.field_151585_k, Material.field_151582_l, Material.field_151569_G});
    private static final ToolTier tier = ToolTier.HOE;

    public ItemFluxHoe() {
        super(2.0f, ItemFluxHoe.tier.material, null);
        this.func_77637_a(RFDrills.RFDrillsTab);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack) && (block == Blocks.field_150321_G || block == Blocks.field_150395_bd);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack) && effectiveMaterials.contains(block.func_149688_o()) ? this.field_77864_a : 1.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"sickle");
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    private int getEnergyPerUse(ItemStack stack) {
        return Math.round(ItemFluxHoe.tier.energyPerBlock / (EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack) + 1));
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(this.setEnergy(new ItemStack(item, 1, 0), 0));
        list.add(this.setEnergy(new ItemStack(item, 1, 0), ItemFluxHoe.tier.maxEnergy));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(1.0 - (double)this.getEnergyStored(stack) / (double)ItemFluxHoe.tier.maxEnergy, 0.0);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151584_j)) {
            for (int a = x - 1; a <= x + 1; ++a) {
                for (int b = y - 1; b <= y + 1; ++b) {
                    for (int c = z - 1; c <= z + 1; ++c) {
                        if (!world.func_72899_e(a, b, c) || world.func_147437_c(a, b, c) || a == x && b == y && c == z) continue;
                        ToolHelper.harvestBlock(world, a, b, c, player);
                    }
                }
            }
        } else {
            for (int a = x - 1; a <= x + 1; ++a) {
                for (int c = z - 1; c <= z + 1; ++c) {
                    if (!world.func_72899_e(a, y, c) || world.func_147437_c(a, y, c) || a == x && c == z) continue;
                    ToolHelper.harvestBlock(world, a, y, c, player);
                }
            }
        }
        ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)));
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ) {
        if (this.getEnergyStored(stack) == 0) {
            return false;
        }
        if (!ToolHelper.hoeBlock(stack, world, x, y, z, sideHit, player)) {
            return false;
        }
        if (!player.func_70093_af()) {
            for (int a = x - 1; a <= x + 1; ++a) {
                for (int c = z - 1; c <= z + 1; ++c) {
                    if (a == x && c == z) continue;
                    ToolHelper.hoeBlock(stack, world, a, y, c, sideHit, player);
                }
            }
        }
        ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack));
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityAttacked, EntityLivingBase entityAttacker) {
        if (entityAttacker instanceof EntityPlayer) {
            ToolHelper.drainEnergy(stack, (EntityPlayer)entityAttacker, this.getEnergyPerUse(stack) * 2);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean what) {
        try {
            list.add(StringHelper.writeEnergyInfo(this.getEnergyStored(stack), ItemFluxHoe.tier.maxEnergy));
            if (MiscUtil.isShiftPressed()) {
                list.add(StringHelper.writeEnergyPerBlockInfo(this.getEnergyPerUse(stack)));
                list.add(StatCollector.func_74838_a((String)"rfdrills.hoe.tooltip"));
                if (ItemFluxHoe.tier.canBreak) {
                    list.add(StatCollector.func_74838_a((String)"rfdrills.can_break.tooltip"));
                }
                if (this.field_77862_b.func_77995_e() > 0) {
                    list.add(StatCollector.func_74838_a((String)"rfdrills.enchantable.tooltip"));
                }
            } else {
                list.add(cofh.lib.util.helpers.StringHelper.shiftForDetails());
            }
        }
        catch (Exception e) {
            LogHelper.warn("Something went wrong with the tooltips!", new Object[0]);
            e.printStackTrace();
        }
    }

    public String func_77658_a() {
        return "item." + "rfdrills".toLowerCase() + ":" + "flux_hoe";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("rfdrills".toLowerCase() + ":" + "flux_hoe");
    }

    @Override
    public ToolTier getTier(ItemStack stack) {
        return tier;
    }

    @Override
    public ItemStack setEnergy(ItemStack stack, int energy) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", Math.min(energy, this.getMaxEnergyStored(stack)));
        return stack;
    }

    @Override
    public ItemStack drainEnergy(ItemStack stack, int energy) {
        return this.setEnergy(stack, Math.max(this.getEnergyStored(stack) - energy, 0));
    }

    @Override
    public int getEnergyPerUse(ItemStack stack, Block block, int meta) {
        return this.getEnergyPerUse(stack);
    }

    @Override
    public String writeModeInfo(ItemStack stack) {
        return "";
    }

    @Override
    public EnumModType getModType() {
        return EnumModType.OTHER;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int energy = this.getEnergyStored(stack);
        int energyReceived = Math.min(ItemFluxHoe.tier.maxEnergy - energy, Math.min(ItemFluxHoe.tier.rechargeRate, maxReceive));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack stack, int i, boolean b) {
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74764_b("Energy")) {
            return stack.field_77990_d.func_74762_e("Energy");
        }
        stack.field_77990_d.func_74768_a("Energy", 0);
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return ItemFluxHoe.tier.maxEnergy;
    }
}

