/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.item;

import cofh.api.item.IEmpowerableItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.key.IKeyBinding;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.BlockHelper;
import cofh.repack.codechicken.lib.math.MathHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import goldenapple.rfdrills.RFDrills;
import goldenapple.rfdrills.item.EnumModType;
import goldenapple.rfdrills.item.IEnergyTool;
import goldenapple.rfdrills.item.ToolTier;
import goldenapple.rfdrills.util.MiscUtil;
import goldenapple.rfdrills.util.StringHelper;
import goldenapple.rfdrills.util.ToolHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemDrill
extends ItemTool
implements IEnergyTool,
IEqualityOverrideItem,
IEmpowerableItem {
    private static final Set<Material> effectiveMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151596_z, Material.field_151592_s, Material.field_151566_D, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151597_y, Material.field_151573_f, Material.field_151576_e, Material.field_151595_p, Material.field_151589_v});
    private final ToolTier tier;
    private final String name;
    private EnumModType modType;

    public ItemDrill(String name, ToolTier tier) {
        super(1.0f, tier.material, null);
        this.name = name;
        this.tier = tier;
        this.func_77637_a(RFDrills.RFDrillsTab);
        this.setHarvestLevel("pickaxe", tier.material.func_77996_d());
        this.setHarvestLevel("shovel", tier.material.func_77996_d());
    }

    public ItemDrill setModType(EnumModType modType) {
        this.modType = modType;
        return this;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUseWithMode(stack) && effectiveMaterials.contains(block.func_149688_o());
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUseWithMode(stack) && effectiveMaterials.contains(block.func_149688_o()) ? this.field_77864_a : 1.0f;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack, block, meta) && ToolHelper.isToolEffective(stack, block, meta)) {
            if (this.isEmpowered(stack)) {
                return this.field_77864_a / 3.0f;
            }
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass) && this.getEnergyStored(stack) >= this.tier.energyPerBlock) {
            return super.getHarvestLevel(stack, toolClass);
        }
        return -1;
    }

    private int getEnergyPerUse(ItemStack stack) {
        return Math.round(this.tier.energyPerBlock / (EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack) + 1));
    }

    private int getEnergyPerUseWithMode(ItemStack stack) {
        int energy = this.getEnergyPerUse(stack);
        if (this.isEmpowered(stack)) {
            energy *= 3;
        }
        return energy;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(this.setEnergy(new ItemStack(item, 1, 0), 0));
        list.add(this.setEnergy(new ItemStack(item, 1, 0), this.tier.maxEnergy));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.tier.rarity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o()) {
            return !stack.field_77990_d.func_74767_n("isCreativeTabIcon");
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(1.0 - (double)this.getEnergyStored(stack) / (double)this.tier.maxEnergy, 0.0);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && this.getEnergyStored(stack) > 0) {
            int xRadius = 0;
            int yRadius = 0;
            int zRadius = 0;
            if (this.isEmpowered(stack)) {
                if (BlockHelper.getCurrentMousedOverSide((EntityPlayer)player) == 0 || BlockHelper.getCurrentMousedOverSide((EntityPlayer)player) == 1) {
                    switch (MathHelper.floor_double((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                        case 0: {
                            zRadius = 1;
                            break;
                        }
                        case 1: {
                            xRadius = 1;
                            break;
                        }
                        case 2: {
                            zRadius = 1;
                            break;
                        }
                        case 3: {
                            xRadius = 1;
                        }
                    }
                } else {
                    yRadius = 1;
                }
            }
            for (int a = x - xRadius; a <= x + xRadius; ++a) {
                for (int b = y - yRadius; b <= y + yRadius; ++b) {
                    for (int c = z - zRadius; c <= z + zRadius; ++c) {
                        if (!world.func_72899_e(a, b, c) || world.func_147437_c(x, y, z) || a == x && b == y && c == z) continue;
                        ToolHelper.harvestBlock(world, a, b, c, player);
                    }
                }
            }
        }
        ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)));
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityAttacked, EntityLivingBase entityAttacker) {
        if (entityAttacker instanceof EntityPlayer) {
            ToolHelper.drainEnergy(stack, (EntityPlayer)entityAttacker, this.getEnergyPerUse(stack) * 2);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af() && MiscUtil.shouldModeShiftClick(this)) {
            this.setEmpoweredState(stack, !this.isEmpowered(stack));
            this.onStateChange(player, stack);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean what) {
        list.add(StringHelper.writeEnergyInfo(this.getEnergyStored(stack), this.tier.maxEnergy));
        if (MiscUtil.isShiftPressed()) {
            list.add(StringHelper.writeEnergyPerBlockInfo(this.getEnergyPerUseWithMode(stack)));
            if (this.tier.hasModes) {
                list.add(this.writeModeInfo(stack));
            }
            list.add(StatCollector.func_74838_a((String)"rfdrills.drill.tooltip"));
            if (this.tier.canBreak) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.can_break.tooltip"));
            }
            if (this.field_77862_b.func_77995_e() > 0) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.enchantable.tooltip"));
            }
            if (this.tier.hasModes) {
                if (MiscUtil.shouldModeShiftClick(this)) {
                    list.add(StatCollector.func_74838_a((String)"rfdrills.drill_has_modes.sneak.tooltip"));
                } else {
                    list.add(StringHelper.writeModeSwitchInfo("rfdrills.drill_has_modes.tooltip", (IKeyBinding)KeyBindingEmpower.instance));
                }
            }
            if (MiscUtil.isItemSilent(stack)) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.silent.tooltip"));
            }
        } else {
            list.add(cofh.lib.util.helpers.StringHelper.shiftForDetails());
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("rfdrills".toLowerCase() + ":" + this.name);
    }

    public String func_77658_a() {
        return "item." + "rfdrills".toLowerCase() + ":" + this.name;
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + "rfdrills".toLowerCase() + ":" + this.name;
    }

    @Override
    public ToolTier getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public ItemStack setEnergy(ItemStack stack, int energy) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", Math.min(energy, this.getMaxEnergyStored(stack)));
        return stack;
    }

    @Override
    public ItemStack drainEnergy(ItemStack stack, int energy) {
        return this.setEnergy(stack, Math.max(this.getEnergyStored(stack) - energy, 0));
    }

    @Override
    public int getEnergyPerUse(ItemStack stack, Block block, int meta) {
        return this.getEnergyPerUseWithMode(stack);
    }

    @Override
    public String writeModeInfo(ItemStack stack) {
        if (!this.tier.hasModes) {
            return "";
        }
        if (this.isEmpowered(stack)) {
            return StatCollector.func_74838_a((String)"rfdrills.1x3x1.mode");
        }
        return StatCollector.func_74838_a((String)"rfdrills.1x1x1.mode");
    }

    @Override
    public EnumModType getModType() {
        return this.modType;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int energy = this.getEnergyStored(stack);
        int energyReceived = Math.min(this.tier.maxEnergy - energy, Math.min(this.tier.rechargeRate, maxReceive));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74764_b("Energy")) {
            return stack.field_77990_d.func_74762_e("Energy");
        }
        stack.field_77990_d.func_74768_a("Energy", 0);
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return this.tier.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack current, ItemStack previous) {
        return previous.func_77973_b() == current.func_77973_b();
    }

    public boolean isEmpowered(ItemStack stack) {
        if (!this.tier.hasModes) {
            return false;
        }
        if (stack.field_77990_d == null) {
            return false;
        }
        if (stack.field_77990_d.func_74764_b("Mode")) {
            return stack.field_77990_d.func_74771_c("Mode") == 1;
        }
        return false;
    }

    public boolean setEmpoweredState(ItemStack stack, boolean b) {
        if (!this.tier.hasModes) {
            return false;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74774_a("Mode", b ? (byte)1 : 0);
        return true;
    }

    public void onStateChange(EntityPlayer player, ItemStack stack) {
        if (!MiscUtil.isItemSilent(stack)) {
            if (!this.isEmpowered(stack)) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.6f);
            } else {
                player.field_70170_p.func_72956_a((Entity)player, "ambient.weather.thunder", 0.4f, 1.0f);
            }
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(this.writeModeInfo(stack)));
    }
}

