/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.item;

import cofh.api.item.IEmpowerableItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.key.IKeyBinding;
import cofh.core.util.KeyBindingEmpower;
import goldenapple.rfdrills.RFDrills;
import goldenapple.rfdrills.config.ConfigHandler;
import goldenapple.rfdrills.item.EnumModType;
import goldenapple.rfdrills.item.IEnergyTool;
import goldenapple.rfdrills.item.ToolTier;
import goldenapple.rfdrills.util.MiscUtil;
import goldenapple.rfdrills.util.StringHelper;
import goldenapple.rfdrills.util.ToolHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemChainsaw
extends ItemAxe
implements IEnergyTool,
IEqualityOverrideItem,
IEmpowerableItem {
    private final String name;
    private final ToolTier tier;
    private EnumModType modType;

    public ItemChainsaw(String name, ToolTier tier) {
        super(tier.material);
        this.name = name;
        this.tier = tier;
        this.func_77637_a(RFDrills.RFDrillsTab);
    }

    public ItemChainsaw setModType(EnumModType modType) {
        this.modType = modType;
        return this;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(this.setEnergy(new ItemStack(item, 1, 0), 0));
        list.add(this.setEnergy(new ItemStack(item, 1, 0), this.tier.maxEnergy));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.tier.rarity;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (this.getEnergyStored(stack) > 0 && this.isEmpowered(stack)) {
            return block instanceof IShearable || block == Blocks.field_150321_G || block == Blocks.field_150488_af || block == Blocks.field_150473_bD;
        }
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass) && this.getEnergyStored(stack) >= this.tier.energyPerBlock) {
            return super.getHarvestLevel(stack, toolClass);
        }
        return -1;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.getEnergyStored(stack) >= this.getEnergyPerUse(stack, block, meta)) {
            if (block instanceof IShearable && this.isEmpowered(stack)) {
                return 100.0f;
            }
            if (block.func_149688_o() == Material.field_151580_n) {
                return super.getDigSpeed(stack, block, meta) * 3.0f;
            }
            return super.getDigSpeed(stack, block, meta);
        }
        return 1.0f;
    }

    private int getEnergyPerUse(ItemStack stack) {
        return Math.round(this.tier.energyPerBlock / (EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack) + 1));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(1.0 - (double)this.getEnergyStored(stack) / (double)this.tier.maxEnergy, 0.0);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (this.isEmpowered(stack) && this.getEnergyStored(stack) > 0 && Items.field_151097_aZ.func_111207_a(stack, player, entity)) {
            ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack) * 2);
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.isEmpowered(stack) && this.getEnergyStored(stack) > 0) {
            ToolHelper.drainEnergy(stack, player, this.getEnergyPerUse(stack, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z)));
            Items.field_151097_aZ.onBlockStartBreak(stack, x, y, z, player);
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityAttacked, EntityLivingBase entityAttacker) {
        if (entityAttacker instanceof EntityPlayer) {
            ToolHelper.drainEnergy(stack, (EntityPlayer)entityAttacker, this.getEnergyPerUse(stack) * 2);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af() && MiscUtil.shouldModeShiftClick(this)) {
            this.setEmpoweredState(stack, !this.isEmpowered(stack));
            this.onStateChange(player, stack);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean what) {
        list.add(StringHelper.writeEnergyInfo(this.getEnergyStored(stack), this.tier.maxEnergy));
        if (MiscUtil.isShiftPressed()) {
            list.add(StringHelper.writeEnergyPerBlockInfo(this.getEnergyPerUse(stack)));
            if (this.tier.hasModes) {
                list.add(this.writeModeInfo(stack));
            }
            list.add(StatCollector.func_74838_a((String)"rfdrills.chainsaw.tooltip"));
            if (this.tier.canBreak) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.can_break.tooltip"));
            }
            if (this.field_77862_b.func_77995_e() > 0) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.enchantable.tooltip"));
            }
            if (this.tier.hasModes) {
                if (!ConfigHandler.modeShiftClickTE && this.getModType() == EnumModType.TE) {
                    list.add(StringHelper.writeModeSwitchInfo("rfdrills.chainsaw_has_modes.tooltip", (IKeyBinding)KeyBindingEmpower.instance));
                } else if (!ConfigHandler.modeShiftClickEIO && this.getModType() == EnumModType.EIO) {
                    list.add(StringHelper.writeModeSwitchInfo("rfdrills.chainsaw_has_modes.tooltip", (IKeyBinding)KeyBindingEmpower.instance));
                } else {
                    list.add(StatCollector.func_74838_a((String)"rfdrills.chainsaw_has_modes.sneak.tooltip"));
                }
            }
            if (MiscUtil.isItemSilent(stack)) {
                list.add(StatCollector.func_74838_a((String)"rfdrills.silent.tooltip"));
            }
        } else {
            list.add(cofh.lib.util.helpers.StringHelper.shiftForDetails());
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("rfdrills".toLowerCase() + ":" + this.name);
    }

    public String func_77658_a() {
        return "item." + "rfdrills".toLowerCase() + ":" + this.name;
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + "rfdrills".toLowerCase() + ":" + this.name;
    }

    @Override
    public ToolTier getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public ItemStack setEnergy(ItemStack stack, int energy) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("Energy", Math.min(energy, this.getMaxEnergyStored(stack)));
        return stack;
    }

    @Override
    public ItemStack drainEnergy(ItemStack stack, int energy) {
        return this.setEnergy(stack, Math.max(this.getEnergyStored(stack) - energy, 0));
    }

    @Override
    public int getEnergyPerUse(ItemStack stack, Block block, int meta) {
        if (this.isEmpowered(stack)) {
            return block instanceof IShearable ? this.getEnergyPerUse(stack) / 5 : this.getEnergyPerUse(stack);
        }
        return this.getEnergyPerUse(stack);
    }

    @Override
    public String writeModeInfo(ItemStack stack) {
        if (!this.tier.hasModes) {
            return "";
        }
        if (this.isEmpowered(stack)) {
            return StatCollector.func_74838_a((String)"rfdrills.shears_on.mode");
        }
        return StatCollector.func_74838_a((String)"rfdrills.shears_off.mode");
    }

    @Override
    public EnumModType getModType() {
        return this.modType;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        int energy = this.getEnergyStored(stack);
        int energyReceived = Math.min(this.tier.maxEnergy - energy, Math.min(this.tier.rechargeRate, maxReceive));
        if (!simulate) {
            this.setEnergy(stack, energy + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74764_b("Energy")) {
            return stack.field_77990_d.func_74762_e("Energy");
        }
        stack.field_77990_d.func_74768_a("Energy", 0);
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return this.tier.maxEnergy;
    }

    public boolean isEmpowered(ItemStack stack) {
        if (!this.tier.hasModes) {
            return ConfigHandler.shearsDefault;
        }
        if (stack.field_77990_d == null) {
            return ConfigHandler.shearsDefault;
        }
        if (stack.field_77990_d.func_74764_b("Mode")) {
            return stack.field_77990_d.func_74771_c("Mode") == 1;
        }
        return ConfigHandler.shearsDefault;
    }

    public boolean setEmpoweredState(ItemStack stack, boolean b) {
        if (!this.tier.hasModes) {
            return false;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74774_a("Mode", b ? (byte)1 : 0);
        return true;
    }

    public void onStateChange(EntityPlayer player, ItemStack stack) {
        if (!MiscUtil.isItemSilent(stack)) {
            if (!this.isEmpowered(stack)) {
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.6f);
            } else {
                player.field_70170_p.func_72956_a((Entity)player, "ambient.weather.thunder", 0.4f, 1.0f);
            }
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(this.writeModeInfo(stack)));
    }

    public boolean isLastHeldItemEqual(ItemStack current, ItemStack previous) {
        return current.func_77973_b() == previous.func_77973_b();
    }
}

