/*
 * Decompiled with CFR 0.152.
 */
package goldenapple.rfdrills.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import goldenapple.rfdrills.item.ToolTier;
import goldenapple.rfdrills.util.LogHelper;
import java.io.File;
import java.util.Map;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;

public class ConfigHandler {
    public static Configuration config;
    public static boolean integrateTE;
    public static boolean integrateEIO;
    public static boolean integrateRArs;
    public static boolean shearsDefault;
    public static boolean modeShiftClickTE;
    public static boolean modeShiftClickEIO;
    public static int animationType;

    public ConfigHandler(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        this.loadConfig();
    }

    private void loadConfig() {
        if (config.hasCategory("hoe_tier1")) {
            ConfigHandler.renameCategory("hoe_tier1", "hoe");
        }
        if (config.hasCategory("drill_tier5")) {
            ConfigHandler.renameCategory("drill_tier5", "fluxcrusher");
        }
        integrateTE = config.get("general", "Integrate TE", true).setLanguageKey("config.integrateTE").setRequiresMcRestart(true).getBoolean();
        integrateEIO = config.get("general", "Integrate EIO", true).setLanguageKey("config.integrateEIO").setRequiresMcRestart(true).getBoolean();
        integrateRArs = config.get("general", "Integrate Redstone Arsenal", true).setLanguageKey("config.integrateRArs").setRequiresMcRestart(true).getBoolean();
        shearsDefault = config.get("general", "Shears Default", true).setLanguageKey("config.shearsDefault").getBoolean();
        modeShiftClickTE = config.get("general", "TE Mode Switch Shift+Click", false).setLanguageKey("config.modeShiftClickTE").getBoolean();
        modeShiftClickEIO = config.get("general", "EIO Mode Switch Shift+Click", true).setLanguageKey("config.modeShiftClickEIO").getBoolean();
        animationType = config.get("general", "Mining Animation Type", 2).setLanguageKey("config.animationType").setMinValue(0).setMaxValue(2).setRequiresMcRestart(true).getInt();
        ToolTier.DRILL1 = ConfigHandler.getToolTierInfo("drill_tier1", 20000, 80, 80, EnumRarity.common, true, false, 2, 6.0f, 2.0f, 0);
        ToolTier.DRILL2 = ConfigHandler.getToolTierInfo("drill_tier2", 100000, 200, 400, EnumRarity.common, false, false, 3, 8.0f, 3.0f, 0);
        ToolTier.DRILL3 = ConfigHandler.getToolTierInfo("drill_tier3", 1000000, 800, 1500, EnumRarity.uncommon, false, true, 3, 10.0f, 4.0f, 10);
        ToolTier.DRILL4 = ConfigHandler.getToolTierInfo("drill_tier4", 5000000, 1500, 5000, EnumRarity.rare, false, true, 4, 12.0f, 5.0f, 15);
        ToolTier.FLUX_CRUSHER = ConfigHandler.getToolTierInfo("fluxcrusher", 25000000, 5000, 10000, EnumRarity.epic, false, true, 5, 15.0f, 8.0f, 20);
        ToolTier.SOUL_CRUSHER = ConfigHandler.getSoulCrusherTierInfo();
        ToolTier.HOE = ConfigHandler.getHoeTierInfo();
        ToolTier.CHAINSAW1 = ConfigHandler.getToolTierInfo("chainsaw_tier1", 20000, 80, 80, EnumRarity.common, true, false, 2, 6.0f, 3.0f, 0);
        ToolTier.CHAINSAW2 = ConfigHandler.getToolTierInfo("chainsaw_tier2", 100000, 200, 400, EnumRarity.common, false, false, 3, 7.0f, 4.0f, 0);
        ToolTier.CHAINSAW3 = ConfigHandler.getToolTierInfo("chainsaw_tier3", 1000000, 800, 1500, EnumRarity.uncommon, false, true, 3, 10.0f, 5.0f, 10);
        ToolTier.CHAINSAW4 = ConfigHandler.getToolTierInfo("chainsaw_tier4", 5000000, 1500, 5000, EnumRarity.rare, false, true, 4, 12.0f, 6.0f, 15);
        for (String categoryName : config.getCategoryNames()) {
            for (Map.Entry entry : config.getCategory(categoryName).entrySet()) {
                if (((String)entry.getKey()).equals("Enchantablility")) {
                    ConfigHandler.renameProperty(categoryName, (String)entry.getKey(), "Enchantability");
                    continue;
                }
                if (!((String)entry.getKey()).equals("Enchantibility")) continue;
                ConfigHandler.renameProperty(categoryName, (String)entry.getKey(), "Enchantability");
            }
        }
        if (config.getCategory("general").containsKey("TE Mode Switch Sound")) {
            ConfigHandler.removeProperty("general", "TE Mode Switch Sound");
        }
        if (config.getCategory("general").containsKey("EIO Mode Switch Sound")) {
            ConfigHandler.removeProperty("general", "EIO Mode Switch Sound");
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static ToolTier getToolTierInfo(String category, int maxEnergy, int energyPerBlock, int rechargeRate, EnumRarity rarity, boolean canBreak, boolean hasModes, int miningLevel, float efficiency, float damage, int enchant) {
        maxEnergy = config.get(category, "Maximum Energy", maxEnergy).setLanguageKey("config.maxEnergy").setRequiresMcRestart(true).getInt();
        energyPerBlock = config.get(category, "Energy Per Block", energyPerBlock).setLanguageKey("config.energyPerBlock").setRequiresMcRestart(true).getInt();
        rechargeRate = config.get(category, "Recharge Rate", rechargeRate).setLanguageKey("config.rechargeRate").setRequiresMcRestart(true).getInt();
        canBreak = config.get(category, "Can Break", canBreak).setLanguageKey("config.canBreak").setRequiresMcRestart(true).getBoolean();
        hasModes = config.get(category, "Has Modes", hasModes).setLanguageKey("config.hasModes").setRequiresMcRestart(true).getBoolean();
        miningLevel = config.get(category, "Mining Level", miningLevel).setLanguageKey("config.miningLevel").setRequiresMcRestart(true).getInt();
        efficiency = (float)config.get(category, "Efficiency", (double)efficiency).setLanguageKey("config.efficiency").setRequiresMcRestart(true).getDouble();
        damage = (float)config.get(category, "Damage", (double)damage).setLanguageKey("config.damage").setRequiresMcRestart(true).getDouble();
        enchant = config.get(category, "Enchantability", enchant).setLanguageKey("config.enchant").setRequiresMcRestart(true).getInt();
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)("rfdrills:" + category.toUpperCase()), (int)miningLevel, (int)9000, (float)efficiency, (float)damage, (int)enchant);
        return new ToolTier(material, maxEnergy, rechargeRate, energyPerBlock, rarity, canBreak, hasModes);
    }

    private static ToolTier getSoulCrusherTierInfo() {
        int miningLevel = config.get("soulcrusher", "Mining Level", 5).setLanguageKey("config.miningLevel").setRequiresMcRestart(true).getInt();
        float efficiency = (float)config.get("soulcrusher", "Efficiency", 12.0).setLanguageKey("config.efficiency").setRequiresMcRestart(true).getDouble();
        float damage = (float)config.get("soulcrusher", "Damage", 8.0).setLanguageKey("config.damage").setRequiresMcRestart(true).getDouble();
        int enchant = config.get("soulcrusher", "Enchantability", 20).setLanguageKey("config.enchant").setRequiresMcRestart(true).getInt();
        boolean canBreak = config.get("soulcrusher", "Can Break", false).setLanguageKey("config.canBreak").setRequiresMcRestart(true).getBoolean();
        return new ToolTier(EnumHelper.addToolMaterial((String)"rfdrills:SOUL_CRUSHER", (int)miningLevel, (int)9000, (float)efficiency, (float)damage, (int)enchant), 200000, 400, 400, EnumRarity.epic, canBreak, true);
    }

    private static ToolTier getHoeTierInfo() {
        int maxEnergy = config.get("hoe", "Maximum Energy", 20000).setLanguageKey("config.maxEnergy").setRequiresMcRestart(true).getInt();
        int energyPerBlock = config.get("hoe", "Energy Per Block", 80).setLanguageKey("config.energyPerBlock").setRequiresMcRestart(true).getInt();
        int rechargeRate = config.get("hoe", "Recharge Rate", 80).setLanguageKey("config.rechargeRate").setRequiresMcRestart(true).getInt();
        boolean canBreak = config.get("hoe", "Can Break", true).setLanguageKey("config.canBreak").setRequiresMcRestart(true).getBoolean();
        int miningLevel = config.get("hoe", "Mining Level", 2).setLanguageKey("config.miningLevel").setRequiresMcRestart(true).getInt();
        float efficiency = (float)config.get("hoe", "Efficiency", 6.0).setLanguageKey("config.efficiency").setRequiresMcRestart(true).getDouble();
        float damage = (float)config.get("hoe", "Damage", 2.0).setLanguageKey("config.damage").setRequiresMcRestart(true).getDouble();
        int enchant = config.get("hoe", "Enchantability", 0).setLanguageKey("config.enchant").setRequiresMcRestart(true).getInt();
        Item.ToolMaterial material = EnumHelper.addToolMaterial((String)"rfdrills:HOE", (int)miningLevel, (int)9000, (float)efficiency, (float)damage, (int)enchant);
        return new ToolTier(material, maxEnergy, rechargeRate, energyPerBlock, EnumRarity.common, canBreak, false);
    }

    private static void removeProperty(String category, String name) {
        if (config.hasCategory(category) && config.getCategory(category).containsKey(name)) {
            LogHelper.info("Outdated config contains property %s in category %s! Removing..", name, category);
            config.getCategory(category).remove((Object)name);
        }
    }

    private static void renameProperty(String category, String nameOld, String nameNew) {
        LogHelper.info("Outdated config contains property %s in category %s! Renaming to %s...", nameOld, category, nameNew);
        config.renameProperty(category, nameOld, nameNew);
    }

    private static void renameCategory(String categoryOld, String categoryNew) {
        if (config.hasCategory(categoryOld)) {
            LogHelper.info("Outdated config contains category %s! Renaming to %s...", categoryOld, categoryNew);
            for (Map.Entry entry : config.getCategory(categoryOld).entrySet()) {
                config.getCategory(categoryNew).put((String)entry.getKey(), (Property)entry.getValue());
            }
            config.removeCategory(config.getCategory(categoryOld));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("rfdrills")) {
            this.loadConfig();
        }
    }
}

