/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.PropertyModifierIntLinearAdditive;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MagnetModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_MAGNET = "Magnet";
    public static final String MAGNET_ENERGY_CONSUMPTION = "Energy Consumption";
    public static final String MAGNET_RADIUS = "Magnet Radius";

    public MagnetModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty("Weight", 1000.0);
        this.addBaseProperty(MAGNET_RADIUS, 5.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.magnet, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.addBaseProperty(MAGNET_ENERGY_CONSUMPTION, 200.0);
        this.addIntTradeoffProperty(MAGNET_RADIUS, MAGNET_RADIUS, 10.0, "m", 1, 0);
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    @Override
    public String getTextureFile() {
        return "magnetmodule";
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getDataName() {
        return MODULE_MAGNET;
    }

    @Override
    public String getUnlocalizedName() {
        return "magnet";
    }

    @Override
    public String getDescription() {
        return "Generates a magnetic field strong enough to attract items towards the player.         WARNING:                   This module drains power continuously. Turn it off when not needed. (Keybind menu: k)";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack stack) {
        if (ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, MAGNET_ENERGY_CONSUMPTION)) {
            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, MAGNET_ENERGY_CONSUMPTION));
            }
            int range = (int)ModuleManager.computeModularProperty(stack, MAGNET_RADIUS);
            World world = player.field_70170_p;
            AxisAlignedBB bounds = player.field_70121_D.func_72314_b((double)range, (double)range, (double)range);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                bounds.func_72314_b(0.2000000029802322, 0.2000000029802322, 0.2000000029802322);
                if (stack.func_77960_j() >> 1 >= 7) {
                    List arrows = world.func_72872_a(EntityArrow.class, bounds);
                    for (EntityArrow arrow : arrows) {
                        if (arrow.field_70251_a == 1 && world.field_73012_v.nextInt(6) == 0) {
                            EntityItem replacement = new EntityItem(world, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, new ItemStack(Items.field_151032_g));
                            world.func_72838_d((Entity)replacement);
                        }
                        world.func_72900_e((Entity)arrow);
                    }
                }
            }
            List list = world.func_72872_a(EntityItem.class, bounds);
            for (EntityItem e : list) {
                if (e.field_70292_b < 10) continue;
                double x = player.field_70165_t - e.field_70165_t;
                double y = player.field_70163_u - e.field_70163_u;
                double z = player.field_70161_v - e.field_70161_v;
                double length = Math.sqrt(x * x + y * y + z * z) * 0.75;
                x = x / length + player.field_70159_w * 22.0;
                y = y / length + player.field_70181_x / 22.0;
                z = z / length + player.field_70179_y * 22.0;
                e.field_70159_w = x;
                e.field_70181_x = y;
                e.field_70179_y = z;
                e.field_70160_al = true;
                if (e.field_70123_F) {
                    e.field_70181_x += 1.0;
                }
                if (world.field_73012_v.nextInt(20) != 0) continue;
                float pitch = 0.85f - world.field_73012_v.nextFloat() * 3.0f / 10.0f;
                world.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, "mob.endermen.portal", 0.6f, pitch);
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

