/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.MorphTarget;
import net.minecraft.nbt.NBTTagCompound;

public class ModelPartSpec {
    public ModelSpec modelSpec;
    public MorphTarget morph;
    public String partName;
    public int slot;
    public int defaultcolourindex;
    public boolean defaultglow;
    public String displayName;

    public ModelPartSpec(ModelSpec modelSpec, MorphTarget morph, String partName, int slot, Integer defaultcolourindex, Boolean defaultglow, String displayName) {
        this.modelSpec = modelSpec;
        this.morph = morph;
        this.partName = partName;
        this.slot = slot;
        this.defaultcolourindex = defaultcolourindex != null ? defaultcolourindex : 0;
        this.defaultglow = defaultglow != null ? defaultglow : false;
        this.displayName = displayName;
    }

    public String getTexture(NBTTagCompound nbt) {
        return nbt.func_74764_b("texture") ? nbt.func_74779_i("texture") : this.modelSpec.textures[0];
    }

    public void setTexture(NBTTagCompound nbt, String s) {
        if (s.equals("") || s.equalsIgnoreCase(this.modelSpec.textures[0])) {
            nbt.func_82580_o("texture");
        } else {
            nbt.func_74778_a("texture", s);
        }
    }

    public int getColourIndex(NBTTagCompound nbt) {
        return nbt.func_74764_b("colourindex") ? nbt.func_74762_e("colourindex") : this.defaultcolourindex;
    }

    public void setColourIndex(NBTTagCompound nbt, int c) {
        if (c == this.defaultcolourindex) {
            nbt.func_82580_o("colourindex");
        } else {
            nbt.func_74768_a("colourindex", c);
        }
    }

    public boolean getGlow(NBTTagCompound nbt) {
        return nbt.func_74764_b("glow") ? nbt.func_74767_n("glow") : this.defaultglow;
    }

    public void setGlow(NBTTagCompound nbt, boolean g) {
        if (g == this.defaultglow) {
            nbt.func_82580_o("glow");
        } else {
            nbt.func_74757_a("glow", g);
        }
    }

    public void setModel(NBTTagCompound nbt, ModelSpec model) {
        String modelString = (String)ModelRegistry.getInstance().inverse().get((Object)model);
        this.setModel(nbt, modelString != null ? modelString : "");
    }

    public void setModel(NBTTagCompound nbt, String modelname) {
        nbt.func_74778_a("model", modelname);
    }

    public void setPart(NBTTagCompound nbt) {
        nbt.func_74778_a("part", this.partName);
    }

    public void setPartAndModel(NBTTagCompound nbt) {
    }

    public NBTTagCompound multiSet(NBTTagCompound nbt, String tex, Boolean glow, Integer c) {
        this.setPart(nbt);
        this.setModel(nbt, this.modelSpec);
        this.setTexture(nbt, tex != null ? tex : "");
        this.setGlow(nbt, glow != null ? glow : false);
        this.setColourIndex(nbt, c != null ? c : this.defaultcolourindex);
        return nbt;
    }
}

